/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.config;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.config.AbstractCollectionConfigurationLookupStrategy;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;

public class SetConfigurationLookupStrategy<T>
extends AbstractCollectionConfigurationLookupStrategy<T, Set<T>> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(SetConfigurationLookupStrategy.class);

    @Override
    @Nullable
    protected Set<T> doTranslate(@Nonnull IdPAttribute tag) {
        LOG.debug("Converting tag '{}' to Set<{}> property", (Object)tag.getId(), (Object)this.getPropertyType().getSimpleName());
        List<IdPAttributeValue> values = tag.getValues();
        HashSet result = new HashSet(values.size());
        for (IdPAttributeValue value : values) {
            if (value instanceof StringAttributeValue) {
                StringAttributeValue sval = (StringAttributeValue)value;
                try {
                    result.add(this.createInstanceFromString(sval.getValue()));
                }
                catch (Exception e) {
                    LOG.error("Error converting tag value into {}", (Object)this.getPropertyType().getSimpleName(), (Object)e);
                }
                continue;
            }
            if (!(value instanceof XMLObjectAttributeValue)) continue;
            XMLObjectAttributeValue xmlValue = (XMLObjectAttributeValue)value;
            if (!this.getPropertyType().isInstance(xmlValue.getValue())) continue;
            result.add(this.getPropertyType().cast(xmlValue.getValue()));
        }
        return result;
    }

    @Override
    @Nullable
    protected Set<T> doTranslate(@Nonnull Attribute tag) {
        LOG.debug("Converting tag '{}' to Set<> property", (Object)tag.getName());
        List values = tag.getAttributeValues();
        HashSet result = new HashSet(values.size());
        for (XMLObject value : values) {
            assert (value != null);
            String converted = this.xmlObjectToString(value);
            if (converted != null) {
                try {
                    result.add(this.createInstanceFromString(converted));
                }
                catch (Exception e) {
                    LOG.error("Error converting tag value into {}", (Object)this.getPropertyType().getSimpleName(), (Object)e);
                }
                continue;
            }
            if (this.getPropertyType().isInstance(value)) {
                result.add(this.getPropertyType().cast(value));
                continue;
            }
            List children = value.getOrderedChildren();
            if (children == null || children.size() != 1) continue;
            XMLObject child = (XMLObject)children.get(0);
            if (!this.getPropertyType().isInstance(child)) continue;
            result.add(this.getPropertyType().cast(child));
        }
        return result;
    }
}

