/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import jakarta.servlet.ServletException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.servlet.HttpServletRequestValidator;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractHttpServletRequestMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class HttpServletRequestValidationHandler
extends AbstractHttpServletRequestMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(HttpServletRequestValidationHandler.class);
    @NonnullAfterInit
    private HttpServletRequestValidator validator;

    @NonnullAfterInit
    public HttpServletRequestValidator getValidator() {
        return this.validator;
    }

    public void setValidator(@Nullable HttpServletRequestValidator newValidator) {
        this.checkSetterPreconditions();
        this.validator = newValidator;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getValidator() == null) {
            throw new ComponentInitializationException("HttpServletRequestValidator was null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        try {
            this.getValidator().validate(this.getHttpServletRequest());
        }
        catch (ServletException e) {
            throw new MessageHandlerException("HttpServletRequest was invalid", (Exception)((Object)e));
        }
    }
}

