/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.service;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.service.ReloadableService;

public class ReloadableServiceGaugeSet<T>
extends AbstractInitializableComponent
implements MetricSet,
MetricFilter {
    @Nonnull
    private Map<String, Metric> gauges;
    @NonnullAfterInit
    private ReloadableService<T> service;
    @Nonnull
    @NotEmpty
    private final String metricPrefix;

    public ReloadableServiceGaugeSet(@Nonnull @ParameterName(name="metricName") @NotEmpty String metricName) {
        this.metricPrefix = Constraint.isNotEmpty((String)metricName, (String)"Metric name cannot be null or empty");
        this.gauges = new HashMap<String, Metric>();
        this.gauges.put(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"reload", "success"}), (Metric)new Gauge<Instant>(){

            public Instant getValue() {
                return ReloadableServiceGaugeSet.this.service.getLastSuccessfulReloadInstant();
            }
        });
        this.gauges.put(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"reload", "attempt"}), (Metric)new Gauge<Instant>(){

            public Instant getValue() {
                return ReloadableServiceGaugeSet.this.service.getLastReloadAttemptInstant();
            }
        });
        this.gauges.put(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"reload", "error"}), (Metric)new Gauge<String>(){

            public String getValue() {
                Throwable cause = ReloadableServiceGaugeSet.this.service.getReloadFailureCause();
                return cause != null ? cause.getMessage() : null;
            }
        });
    }

    @NonnullAfterInit
    public ReloadableService<T> getService() {
        return this.service;
    }

    public void setService(@Nonnull ReloadableService<T> svc) {
        this.checkSetterPreconditions();
        this.service = (ReloadableService)Constraint.isNotNull(svc, (String)"ReloadableService cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.service == null) {
            throw new ComponentInitializationException("ReloadableService cannot be null");
        }
    }

    public Map<String, Metric> getMetrics() {
        return CollectionSupport.copyToMap(this.gauges);
    }

    public boolean matches(String name, Metric metric) {
        return this.gauges.containsKey(name);
    }

    @Nonnull
    @Live
    protected Map<String, Metric> getMetricMap() {
        return this.gauges;
    }

    @Nonnull
    @NotEmpty
    protected final String getLogPrefix() {
        return this.metricPrefix;
    }
}

