/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.ar.impl;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.consent.context.AttributeReleaseContext;
import net.shibboleth.idp.consent.flow.ar.impl.AbstractAttributeReleaseAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulateAttributeReleaseContext
extends AbstractAttributeReleaseAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateAttributeReleaseContext.class);
    @NonnullAfterInit
    private Predicate<IdPAttribute> attributePredicate;
    @Nullable
    private Comparator<String> attributeIdComparator;

    public void setAttributePredicate(@Nonnull Predicate<IdPAttribute> predicate) {
        this.attributePredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Attribute predicate cannot be null");
    }

    public void setAttributeIdComparator(@Nullable Comparator<String> comparator) {
        this.attributeIdComparator = comparator;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributePredicate == null) {
            throw new ComponentInitializationException("Attribute predicate cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        AttributeContext attributeContext = this.getAttributeContext();
        assert (attributeContext != null);
        Map attributes = attributeContext.getIdPAttributes();
        TreeMap<String, IdPAttribute> consentableAttributes = new TreeMap<String, IdPAttribute>(this.attributeIdComparator);
        for (IdPAttribute attribute : attributes.values()) {
            if (!this.attributePredicate.test(attribute)) continue;
            consentableAttributes.put(attribute.getId(), attribute);
        }
        AttributeReleaseContext releaseContext = this.getAttributeReleaseContext();
        assert (releaseContext != null);
        releaseContext.getConsentableAttributes().putAll(consentableAttributes);
        this.log.debug("{} Consentable attribute IDs '{}'", (Object)this.getLogPrefix(), consentableAttributes.keySet());
        this.log.trace("{} Consentable attributes '{}'", (Object)this.getLogPrefix(), consentableAttributes);
    }
}

