/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function.support;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.web.accept.ApiVersionStrategy;
import org.springframework.web.accept.DefaultApiVersionStrategy;
import org.springframework.web.filter.ServerHttpObservationFilter;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.support.SupportedVersionVisitor;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;
import org.springframework.web.servlet.handler.RequestMatchResult;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class RouterFunctionMapping
extends AbstractHandlerMapping
implements InitializingBean,
MatchableHandlerMapping {
    private @Nullable RouterFunction<?> routerFunction;
    private List<HttpMessageConverter<?>> messageConverters = Collections.emptyList();
    private boolean detectHandlerFunctionsInAncestorContexts = false;

    public RouterFunctionMapping() {
    }

    public RouterFunctionMapping(RouterFunction<?> routerFunction) {
        this.routerFunction = routerFunction;
    }

    public void setRouterFunction(@Nullable RouterFunction<?> routerFunction) {
        this.routerFunction = routerFunction;
    }

    public @Nullable RouterFunction<?> getRouterFunction() {
        return this.routerFunction;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    public void setDetectHandlerFunctionsInAncestorContexts(boolean detectHandlerFunctionsInAncestorContexts) {
        this.detectHandlerFunctionsInAncestorContexts = detectHandlerFunctionsInAncestorContexts;
    }

    public void afterPropertiesSet() {
        if (this.routerFunction == null) {
            this.initRouterFunctions();
        }
        if (CollectionUtils.isEmpty(this.messageConverters)) {
            this.initMessageConverters();
        }
        if (this.routerFunction != null) {
            DefaultApiVersionStrategy davs;
            PathPatternParser patternParser = this.getPatternParser();
            if (patternParser == null) {
                patternParser = new PathPatternParser();
                this.setPatternParser(patternParser);
            }
            RouterFunctions.changeParser(this.routerFunction, patternParser);
            ApiVersionStrategy apiVersionStrategy = this.getApiVersionStrategy();
            if (apiVersionStrategy instanceof DefaultApiVersionStrategy && (davs = (DefaultApiVersionStrategy)apiVersionStrategy).detectSupportedVersions()) {
                this.routerFunction.accept(new SupportedVersionVisitor(davs));
            }
        }
    }

    private void initRouterFunctions() {
        List<RouterFunction<?>> routerFunctions = this.obtainApplicationContext().getBeanProvider(RouterFunction.class).orderedStream().map(router -> router).collect(Collectors.toList());
        ApplicationContext parentContext = this.obtainApplicationContext().getParent();
        if (parentContext != null && !this.detectHandlerFunctionsInAncestorContexts) {
            parentContext.getBeanProvider(RouterFunction.class).stream().forEach(routerFunctions::remove);
        }
        this.routerFunction = routerFunctions.stream().reduce(RouterFunction::andOther).orElse(null);
        this.logRouterFunctions(routerFunctions);
    }

    private void logRouterFunctions(List<RouterFunction<?>> routerFunctions) {
        if (this.mappingsLogger.isDebugEnabled()) {
            routerFunctions.forEach(function -> this.mappingsLogger.debug((Object)("Mapped " + String.valueOf(function))));
        } else if (this.logger.isDebugEnabled()) {
            int total = routerFunctions.size();
            String message = total + " RouterFunction(s) in " + this.formatMappingName();
            if (this.logger.isTraceEnabled()) {
                if (total > 0) {
                    routerFunctions.forEach(function -> this.logger.trace((Object)("Mapped " + String.valueOf(function))));
                } else {
                    this.logger.trace((Object)message);
                }
            } else if (total > 0) {
                this.logger.debug((Object)message);
            }
        }
    }

    private void initMessageConverters() {
        ArrayList messageConverters = new ArrayList(4);
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        this.messageConverters = messageConverters;
    }

    @Override
    protected @Nullable Object getHandlerInternal(HttpServletRequest servletRequest) throws Exception {
        if (this.routerFunction == null) {
            return null;
        }
        ServerRequest request = ServerRequest.create(servletRequest, this.messageConverters, this.getApiVersionStrategy());
        HandlerFunction handlerFunction = this.routerFunction.route(request).orElse(null);
        this.setAttributes(servletRequest, request, handlerFunction);
        return handlerFunction;
    }

    private void setAttributes(HttpServletRequest servletRequest, ServerRequest request, @Nullable HandlerFunction<?> handlerFunction) {
        PathPattern matchingPattern = (PathPattern)servletRequest.getAttribute(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE);
        if (matchingPattern != null) {
            servletRequest.removeAttribute(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE);
            servletRequest.setAttribute(BEST_MATCHING_PATTERN_ATTRIBUTE, (Object)matchingPattern.getPatternString());
            ServerHttpObservationFilter.findObservationContext((HttpServletRequest)request.servletRequest()).ifPresent(context -> context.setPathPattern(matchingPattern.getPatternString()));
        }
        servletRequest.setAttribute(BEST_MATCHING_HANDLER_ATTRIBUTE, handlerFunction);
        servletRequest.setAttribute(RouterFunctions.REQUEST_ATTRIBUTE, (Object)request);
    }

    @Override
    @Deprecated(since="7.0", forRemoval=true)
    public @Nullable RequestMatchResult match(HttpServletRequest request, String pattern) {
        throw new UnsupportedOperationException("This HandlerMapping uses PathPatterns");
    }
}

