/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.conf.impl;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.spring.IdPPropertiesApplicationContextInitializer;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.context.DelimiterAwareApplicationContext;
import org.slf4j.Logger;
import org.springframework.web.context.ContextLoaderListener;

public class SpringConfigServletContextInitializer
implements ServletContainerInitializer {
    @Nonnull
    @NotEmpty
    public static final String INIT_PARAMETER_ACTIVATION = "net.shibboleth.idp.registerSpringConfig";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringConfigServletContextInitializer.class);

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        String flag = ctx.getInitParameter(INIT_PARAMETER_ACTIVATION);
        if (!"true".equalsIgnoreCase(flag)) {
            this.log.info("Spring config registration is disabled");
            return;
        }
        this.log.info("Setting init parameters and installing Spring listener");
        ctx.setInitParameter("contextClass", DelimiterAwareApplicationContext.class.getName());
        ctx.setInitParameter("contextInitializerClasses", IdPPropertiesApplicationContextInitializer.class.getName());
        ctx.setInitParameter("contextConfigLocation", "classpath*:/META-INF/net.shibboleth.idp/preconfig.xml,classpath:/net/shibboleth/idp/conf/global-system.xml,classpath*:/META-INF/net.shibboleth.idp/postconfig.xml");
        ctx.addListener(ContextLoaderListener.class.getName());
    }
}

