/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.conf.impl;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.servlet.AbstractConditionalFilter;
import net.shibboleth.shared.servlet.HttpServletSupport;
import net.shibboleth.shared.spring.servlet.ChainableFilter;
import org.slf4j.MDC;

public class SLF4JMDCServletFilter
extends AbstractConditionalFilter
implements ChainableFilter {
    @Nonnull
    @NotEmpty
    public static final String SERVER_ADDRESS_MDC_ATTRIBUTE = "idp.server_hostname";
    @Nonnull
    @NotEmpty
    public static final String SERVER_PORT_MDC_ATTRIBUTE = "idp.server_port";
    @Nonnull
    @NotEmpty
    public static final String CLIENT_ADDRESS_MDC_ATTRIBUTE = "idp.remote_addr";
    @Nonnull
    @NotEmpty
    public static final String JSESSIONID_MDC_ATTRIBUTE = "idp.jsessionid";
    private boolean createSession = true;
    @Nullable
    private Map<String, String> headerMap;

    public void setCreateSession(boolean flag) {
        this.createSession = flag;
    }

    public void setHeaderMap(@Nullable Map<String, String> map) {
        this.headerMap = map != null ? CollectionSupport.copyToMap(map) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runFilter(@Nonnull ServletRequest request, @Nonnull ServletResponse response, @Nonnull FilterChain chain) throws IOException, ServletException {
        try {
            HttpSession session;
            MDC.put((String)"idp.version", (String)Version.getVersion());
            MDC.put((String)CLIENT_ADDRESS_MDC_ATTRIBUTE, (String)HttpServletSupport.getRemoteAddr((ServletRequest)request));
            MDC.put((String)SERVER_ADDRESS_MDC_ATTRIBUTE, (String)request.getServerName());
            MDC.put((String)SERVER_PORT_MDC_ATTRIBUTE, (String)Integer.toString(request.getServerPort()));
            if (this.headerMap != null && request instanceof HttpServletRequest) {
                HttpServletRequest http = (HttpServletRequest)request;
                this.headerMap.entrySet().forEach(entry -> MDC.put((String)((String)entry.getKey()), (String)http.getHeader((String)entry.getValue())));
            }
            if (request instanceof HttpServletRequest && (session = ((HttpServletRequest)request).getSession(this.createSession)) != null) {
                MDC.put((String)JSESSIONID_MDC_ATTRIBUTE, (String)session.getId());
            }
            chain.doFilter(request, response);
        }
        finally {
            MDC.clear();
        }
    }
}

