/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.saml.saml2.profile.config;

import java.time.Duration;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.AttributeResolvingProfileConfiguration;
import net.shibboleth.saml.profile.config.SAMLArtifactConsumerProfileConfiguration;
import net.shibboleth.saml.profile.config.SAMLAssertionConsumingProfileConfiguration;
import net.shibboleth.saml.saml2.profile.config.SAML2ProfileConfiguration;
import net.shibboleth.shared.annotation.ConfigurationSetting;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;

public interface BrowserSSOProfileConfiguration
extends AttributeResolvingProfileConfiguration,
SAMLArtifactConsumerProfileConfiguration,
SAML2ProfileConfiguration,
SAMLAssertionConsumingProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml2/sso/browser";
    public static final int FEATURE_AUTHNCONTEXT = 1;
    public static final int FEATURE_SCOPING = 2;
    public static final int FEATURE_NAMEIDFORMAT = 4;
    public static final int FEATURE_SPNAMEQUALIFIER = 8;
    public static final int FEATURE_FORCEAUTHN = 16;

    @ConfigurationSetting(name="forceAuthn")
    public boolean isForceAuthn(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="checkAddress")
    public boolean isCheckAddress(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="checkInResponseTo")
    public boolean isCheckInResponseTo(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="maximumTimeSinceAuthn")
    @Nullable
    @NonNegative
    public Duration getMaximumTimeSinceAuthn(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="proxyCount")
    @Nullable
    @NonNegative
    public Integer getProxyCount(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="authnContextComparison")
    @Nullable
    public AuthnContextComparisonTypeEnumeration getAuthnContextComparison(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="sPNameQualifier")
    @Nullable
    public String getSPNameQualifier(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="attributeIndex")
    @Nullable
    public Integer getAttributeIndex(@Nullable ProfileRequestContext var1);

    @ConfigurationSetting(name="requestedAttributes")
    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<RequestedAttribute> getRequestedAttributes(@Nullable ProfileRequestContext var1);
}

