/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.opensaml.saml.saml1.core.AttributeQuery;
import org.opensaml.saml.saml1.core.Request;
import org.slf4j.Logger;

public class FilterByQueriedAttributeDesignators
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FilterByQueriedAttributeDesignators.class);
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;
    @Nonnull
    private Function<ProfileRequestContext, Request> requestLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @NonnullBeforeExec
    private AttributeQuery query;
    @NonnullBeforeExec
    private AttributeContext attributeContext;

    public FilterByQueriedAttributeDesignators() {
        Function acls = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
        Function rls = new MessageLookup(Request.class).compose((Function)new InboundMessageContextLookup());
        assert (acls != null && rls != null);
        this.attributeContextLookupStrategy = acls;
        this.requestLookupStrategy = rls;
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        this.checkSetterPreconditions();
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, Request> strategy) {
        this.checkSetterPreconditions();
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request lookup strategy cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.checkSetterPreconditions();
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AttributeQuery ac;
        List designators;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        Request request = this.requestLookupStrategy.apply(profileRequestContext);
        if (request != null) {
            this.query = request.getAttributeQuery();
        }
        List list = designators = (ac = this.query) == null ? null : ac.getAttributeDesignators();
        if (ac == null || designators == null || designators.isEmpty()) {
            this.log.debug("No AttributeDesignators found, nothing to do ");
            return false;
        }
        this.attributeContext = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeContext == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        assert (this.attributeContext != null);
        if (this.attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} No attributes to filter", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HashSet<String> decodedAttributeIds = new HashSet<String>();
        try (ServiceableComponent component = this.transcoderRegistry.getServiceableComponent();){
            for (AttributeDesignator designator : this.query.getAttributeDesignators()) {
                assert (designator != null);
                try {
                    this.decodeAttributeDesignator((AttributeTranscoderRegistry)component.getComponent(), profileRequestContext, designator, decodedAttributeIds);
                }
                catch (AttributeDecodingException e) {
                    this.log.warn("{} Error decoding AttributeDesignators", (Object)this.getLogPrefix(), (Object)e);
                }
            }
        }
        catch (ServiceException e) {
            this.log.error("Attribute transcoder service unavailable", (Throwable)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
            return;
        }
        HashMap<String, IdPAttribute> keepers = new HashMap<String, IdPAttribute>(this.query.getAttributeDesignators().size());
        this.log.debug("Query content mapped to attribute IDs: {}", decodedAttributeIds);
        for (IdPAttribute attribute : this.attributeContext.getIdPAttributes().values()) {
            if (decodedAttributeIds.contains(attribute.getId())) {
                this.log.debug("Retaining attribute '{}' requested by query", (Object)attribute.getId());
                keepers.put(attribute.getId(), attribute);
                continue;
            }
            this.log.debug("Removing attribute '{}' not requested by query", (Object)attribute.getId());
        }
        this.attributeContext.setIdPAttributes(keepers);
    }

    private void decodeAttributeDesignator(@Nonnull AttributeTranscoderRegistry registry, @Nonnull ProfileRequestContext profileRequestContext, @Nonnull AttributeDesignator input, @Nonnull @Live Collection<String> results) throws AttributeDecodingException {
        Collection transcodingRules = registry.getTranscodingRules((Object)input);
        if (transcodingRules.isEmpty()) {
            throw new AttributeDecodingException("No transcoding rule for AttributeDesignator '" + input.getAttributeName() + "'");
        }
        for (TranscodingRule rules : transcodingRules) {
            assert (rules != null);
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rules);
            IdPAttribute decodedAttribute = transcoder.decode(profileRequestContext, (Object)input, rules);
            if (decodedAttribute == null) continue;
            results.add(decodedAttribute.getId());
        }
    }
}

