/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SSODescriptor;
import org.slf4j.Logger;

public abstract class AbstractNameIDFormatExactPolicyRule
extends AbstractPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractNameIDFormatExactPolicyRule.class);
    @NonnullAfterInit
    @NotEmpty
    private String nameIdFormat;

    @NonnullAfterInit
    @NotEmpty
    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    public void setNameIdFormat(@Nullable String format) {
        this.checkSetterPreconditions();
        this.nameIdFormat = StringSupport.trimOrNull((String)format);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.nameIdFormat) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No NameID format specified");
        }
    }

    @Nullable
    protected abstract SSODescriptor getEntitySSODescriptor(@Nonnull AttributeFilterContext var1);

    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        this.checkComponentActive();
        SSODescriptor role = this.getEntitySSODescriptor(filterContext);
        if (role == null) {
            return PolicyRequirementRule.Tristate.FALSE;
        }
        List supportedFormats = role.getNameIDFormats();
        if (supportedFormats == null || supportedFormats.isEmpty()) {
            this.log.debug("{} Entity SSO role descriptor does not list any supported NameID formats", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FALSE;
        }
        for (NameIDFormat supportedFormat : supportedFormats) {
            if (!this.nameIdFormat.equals(supportedFormat.getURI())) continue;
            this.log.debug("{} Entity does support the NameID format '{}'", (Object)this.getLogPrefix(), (Object)this.nameIdFormat);
            return PolicyRequirementRule.Tristate.TRUE;
        }
        this.log.debug("{} Entity does not support the NameID format '{}'", (Object)this.getLogPrefix(), (Object)this.nameIdFormat);
        return PolicyRequirementRule.Tristate.FALSE;
    }
}

