/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.saml.common.profile.logic.EntityGroupNamePredicate;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;

public abstract class AbstractEntityGroupPolicyRule
extends AbstractPolicyRule {
    @NonnullAfterInit
    @NotEmpty
    private String entityGroup;
    private boolean checkAffiliations;

    @NonnullAfterInit
    @NotEmpty
    public String getEntityGroup() {
        return this.entityGroup;
    }

    public void setEntityGroup(@Nullable String group) {
        this.checkSetterPreconditions();
        this.entityGroup = StringSupport.trimOrNull((String)group);
    }

    public void setCheckAffiliations(boolean flag) {
        this.checkSetterPreconditions();
        this.checkAffiliations = flag;
    }

    public boolean isCheckAffiliations() {
        return this.checkAffiliations;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.entityGroup == null) {
            throw new ComponentInitializationException("entityGroup cannot be null");
        }
    }

    @Nullable
    protected abstract EntityDescriptor getEntityMetadata(@Nonnull AttributeFilterContext var1);

    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext input) {
        this.checkComponentActive();
        Constraint.isNotNull((Object)input, (String)"Context must be supplied");
        EntityDescriptor entity = this.getEntityMetadata(input);
        if (entity == null) {
            return PolicyRequirementRule.Tristate.FALSE;
        }
        assert (this.entityGroup != null);
        Set entityGroupAsSet = CollectionSupport.singleton((Object)this.entityGroup);
        EntityGroupNamePredicate predicate = new EntityGroupNamePredicate((Collection)entityGroupAsSet, this.checkAffiliations ? input.getMetadataResolver() : null);
        return predicate.test(entity) ? PolicyRequirementRule.Tristate.TRUE : PolicyRequirementRule.Tristate.FALSE;
    }
}

