/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.logic.impl;

import com.google.common.base.MoreObjects;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public final class NotMatcher
extends AbstractIdentifiableInitializableComponent
implements Matcher {
    @NonnullAfterInit
    private Matcher negatedMatcher;

    public void setNegation(@Nonnull Matcher valueMatcher) {
        this.negatedMatcher = (Matcher)Constraint.isNotNull((Object)valueMatcher, (String)"Attribute value matcher can not be null");
    }

    @Nonnull
    public Matcher getNegatedMatcher() {
        this.checkComponentActive();
        assert (this.negatedMatcher != null);
        return this.negatedMatcher;
    }

    @Nullable
    @Unmodifiable
    @NotLive
    public Set<IdPAttributeValue> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)attribute, (String)"Attribute to be filtered can not be null");
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context can not be null");
        Matcher currentMatcher = this.getNegatedMatcher();
        this.checkComponentActive();
        LinkedHashSet attributeValues = new LinkedHashSet(attribute.getValues());
        Set matches = currentMatcher.getMatchingValues(attribute, filterContext);
        if (null == matches) {
            return matches;
        }
        attributeValues.removeAll(matches);
        if (attributeValues.isEmpty()) {
            return CollectionSupport.emptySet();
        }
        return CollectionSupport.copyToSet(attributeValues);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.negatedMatcher) {
            throw new ComponentInitializationException("No matcher supplied to negate");
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("negatedMatcher", (Object)this.negatedMatcher).toString();
    }
}

