/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.transcoding.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.spring.resource.ResourceHelper;
import org.slf4j.Logger;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class TranscodingRuleLoader {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(TranscodingRuleLoader.class);
    @Nonnull
    private final Collection<TranscodingRule> rules;

    public TranscodingRuleLoader(@Nonnull @ParameterName(name="dir") Path dir, @Nullable @ParameterName(name="extensions") Collection<String> extensions) throws IOException {
        this.log.debug("Loading rules from directory ({})", (Object)dir);
        ArrayList<TranscodingRule> holder = new ArrayList<TranscodingRule>();
        try (DirectoryStream<Path> dirstream = Files.newDirectoryStream(dir);){
            for (Path child : dirstream) {
                File file = child.toFile();
                if (file.isDirectory()) {
                    try {
                        holder.addAll(new TranscodingRuleLoader(child, extensions).getRules());
                    }
                    catch (IOException e) {
                        this.log.error("Failed to load rules from directory ({})", (Object)file, (Object)e);
                    }
                    continue;
                }
                if (extensions == null || extensions.isEmpty() || PredicateSupport.anyMatch(ext -> file.getName().endsWith((String)ext)).test(extensions)) {
                    this.log.debug("Loading rule from property set in file ({})", (Object)file);
                    try {
                        TranscodingRule rule = TranscodingRule.fromResource((net.shibboleth.shared.resource.Resource)ResourceHelper.of((Resource)new FileSystemResource(file)));
                        if (rule.getMap().isEmpty()) {
                            this.log.info("Transcoding file {} contained no rules", (Object)child);
                            continue;
                        }
                        holder.add(rule);
                    }
                    catch (IOException e) {
                        this.log.error("Failed to load rule from file ({})", (Object)file, (Object)e);
                    }
                    continue;
                }
                this.log.debug("Ignoring file ({}) with non-matching extension", (Object)file);
            }
        }
        this.rules = CollectionSupport.copyToList(holder);
    }

    public TranscodingRuleLoader(@Nonnull @ParameterName(name="dir") Path dir) throws IOException {
        this(dir, null);
    }

    public TranscodingRuleLoader(@Nonnull @ParameterName(name="maps") Collection<Map<String, Object>> maps) {
        Constraint.isNotNull(maps, (String)"Input collection cannot be null");
        this.rules = (Collection)((NonnullSupplier)maps.stream().map(m -> {
            assert (m != null);
            return new TranscodingRule(m);
        }).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<TranscodingRule> getRules() {
        return this.rules;
    }
}

