/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import com.beust.jcommander.JCommander;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cli.CommandLineArguments;
import net.shibboleth.shared.annotation.constraint.NotEmpty;

public final class CLI {
    @Nonnull
    @NotEmpty
    public static final String ARGS_PROPERTY = "net.shibboleth.idp.cli.arguments";

    private CLI() {
    }

    public static void main(@Nonnull String[] args) throws ReflectiveOperationException, SecurityException, IllegalArgumentException {
        String msg;
        String argType = System.getProperty(ARGS_PROPERTY);
        if (argType == null) {
            CLI.errorAndExit("net.shibboleth.idp.cli.arguments system property not set");
        }
        CommandLineArguments argObject = null;
        try {
            Constructor<?> construct = Class.forName(argType).getConstructor(new Class[0]);
            Object obj = construct.newInstance(new Object[0]);
            if (!(obj instanceof CommandLineArguments)) {
                CLI.errorAndExit("Argument class was not of the correct type");
            }
            argObject = (CommandLineArguments)obj;
            JCommander jc = new JCommander((Object)argObject);
            jc.parse(args);
            if (argObject.isUsage()) {
                jc.usage();
                return;
            }
        }
        catch (ClassNotFoundException e) {
            CLI.errorAndExit("Argument class " + argType + " not found ");
        }
        catch (IllegalAccessException | InstantiationException e) {
            msg = e.getMessage();
            assert (msg != null);
            CLI.errorAndExit(msg);
        }
        assert (argObject != null);
        try {
            argObject.validate();
        }
        catch (IllegalArgumentException e) {
            msg = e.getMessage();
            assert (msg != null);
            CLI.errorAndExit(msg);
        }
        CLI.doRequest(argObject);
    }

    private static void doRequest(@Nonnull CommandLineArguments args) {
        URL url = null;
        try {
            Map<String, String> headers;
            String authorization;
            url = args.buildURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (args.getMethod() != null) {
                connection.setRequestMethod(args.getMethod());
            }
            if ((authorization = args.getBasicAuthHeader()) != null) {
                connection.setRequestProperty("Authorization", authorization);
            }
            if ((headers = args.getHeaders()) != null) {
                for (Map.Entry<String, String> h : headers.entrySet()) {
                    connection.setRequestProperty(h.getKey(), h.getValue());
                }
            }
            try (InputStream stream = connection.getInputStream();
                 InputStreamReader reader = new InputStreamReader(stream);
                 BufferedReader in = new BufferedReader(reader);){
                String line;
                while ((line = in.readLine()) != null) {
                    System.out.println(line);
                }
            }
        }
        catch (MalformedURLException | ProtocolException e) {
            String msg = e.getMessage();
            assert (msg != null);
            CLI.errorAndExit(msg);
        }
        catch (FileNotFoundException e) {
            CLI.errorAndExit(e.getMessage() + " returned File Not Found error (check IDP_BASE_URL?)");
        }
        catch (IOException e) {
            CLI.errorAndExit((String)(url != null ? "(" + url.toString() + ") " : "") + e.getMessage());
        }
    }

    private static void errorAndExit(@Nonnull String errorMessage) {
        System.err.println(errorMessage);
        System.exit(1);
    }
}

