/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLineArguments;
import net.shibboleth.idp.spring.IdPPropertiesApplicationContextInitializer;
import net.shibboleth.shared.cli.AbstractCommandLine;
import org.apache.hc.client5.http.classic.HttpClient;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextInitializer;

public abstract class AbstractIdPHomeAwareCommandLine<T extends AbstractIdPHomeAwareCommandLineArguments>
extends AbstractCommandLine<T> {
    @Nullable
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    @Nullable
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Nullable
    public HttpClientSecurityParameters getHttpClientSecurityParameters() {
        return this.httpClientSecurityParameters;
    }

    protected int doRun(@Nonnull T args) {
        String securityParameterstName;
        if (((AbstractIdPHomeAwareCommandLineArguments)((Object)args)).getIdPHome() != null) {
            System.setProperty("idp.home", ((AbstractIdPHomeAwareCommandLineArguments)((Object)args)).getIdPHome());
        }
        this.setContextInitializer((ApplicationContextInitializer)new IdPPropertiesApplicationContextInitializer());
        int rc = super.doRun(args);
        if (rc != 0) {
            return rc;
        }
        String clientName = ((AbstractIdPHomeAwareCommandLineArguments)((Object)args)).getHttpClientName();
        if (clientName != null) {
            try {
                this.httpClient = (HttpClient)this.getApplicationContext().getBean(clientName, HttpClient.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                this.getLogger().error("Could not locate HttpClient '{}'", (Object)((AbstractIdPHomeAwareCommandLineArguments)((Object)args)).getHttpClientName());
                return 2;
            }
        }
        if ((securityParameterstName = ((AbstractIdPHomeAwareCommandLineArguments)((Object)args)).getHttpClientSecurityParameterstName()) != null) {
            try {
                this.httpClientSecurityParameters = (HttpClientSecurityParameters)this.getApplicationContext().getBean(securityParameterstName, HttpClientSecurityParameters.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                this.getLogger().error("Could not locate HttpClientSecurityParameters '{}'", (Object)((AbstractIdPHomeAwareCommandLineArguments)((Object)args)).getHttpClientSecurityParameterstName());
                return 2;
            }
        }
        return 0;
    }
}

