/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.ad.impl.ContextDerivedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.spring.ad.BaseAttributeDefinitionParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SubjectDerivedAttributeDefinitionParser
extends BaseAttributeDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "SubjectDerivedAttribute");
    @Nullable
    private Class<? extends Function<?, ?>> subjectDerivedClass;
    @Nullable
    private Class<? extends Function<?, ?>> principalDerivedClass;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SubjectDerivedAttributeDefinitionParser.class);

    public SubjectDerivedAttributeDefinitionParser() {
        try {
            String className = SubjectDerivedAttributeDefinitionParser.getCustomProperty((String)(((Object)((Object)this)).getClass().getName() + ".SubjectDerivedAttributeValuesFunction.class"), null);
            if (className == null) {
                throw new ClassNotFoundException();
            }
            this.subjectDerivedClass = Class.forName(className);
            className = SubjectDerivedAttributeDefinitionParser.getCustomProperty((String)(((Object)((Object)this)).getClass().getName() + ".PrincipalDerivedValuesFunction.class"), null);
            if (className == null) {
                throw new ClassNotFoundException();
            }
            this.principalDerivedClass = Class.forName(className);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            this.log.error("Unable to load classes to support instantiation of this plugin type");
        }
    }

    @Nullable
    protected Class<ContextDerivedAttributeDefinition> getBeanClass(@Nonnull Element element) {
        return ContextDerivedAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        if (this.subjectDerivedClass == null) {
            throw new BeanCreationException("Unable to load class for subject-derived attribute function.");
        }
        super.doParse(config, parserContext, builder);
        String attributeName = StringSupport.trimOrNull((String)config.getAttributeNS(null, "principalAttributeName"));
        String functionRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, "attributeValuesFunctionRef"));
        assert (this.subjectDerivedClass != null);
        BeanDefinitionBuilder contextFunctionBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.subjectDerivedClass);
        contextFunctionBuilder.setInitMethodName("initialize");
        contextFunctionBuilder.setDestroyMethodName("destroy");
        contextFunctionBuilder.addPropertyValue("id", (Object)this.getDefinitionId());
        if (config.hasAttributeNS(null, "forCanonicalization")) {
            contextFunctionBuilder.addPropertyValue("forCanonicalization", (Object)SpringSupport.getStringValueAsBoolean((String)config.getAttributeNS(null, "forCanonicalization")));
        }
        if (null != attributeName) {
            if (null != functionRef) {
                this.log.warn("{} only one of \"principalAttributeName\" or \"attributeValuesFunctionRef\" should be provided. \"attributeValuesFunctionRef\" ignored", (Object)this.getLogPrefix());
            }
            if (this.principalDerivedClass == null) {
                throw new BeanCreationException("Unable to load class for principal-derived attribute function.");
            }
            assert (this.principalDerivedClass != null);
            BeanDefinitionBuilder principalValuesFunctionBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.principalDerivedClass);
            principalValuesFunctionBuilder.addPropertyValue("attributeName", (Object)attributeName);
            contextFunctionBuilder.addPropertyValue("attributeValuesFunction", (Object)principalValuesFunctionBuilder.getBeanDefinition());
        } else if (null != functionRef) {
            contextFunctionBuilder.addPropertyReference("attributeValuesFunction", functionRef);
        } else {
            this.log.error("{} one of \"principalAttributeName\" or \"attributeValuesFunctionRef\" should be supplied. should be provided.", (Object)this.getLogPrefix());
            throw new BeanCreationException("Misconfigured PrincipalDerivedAttribute.");
        }
        builder.addPropertyValue("attributeValuesFunction", (Object)contextFunctionBuilder.getBeanDefinition());
    }

    @Override
    protected boolean failOnDependencies() {
        return true;
    }
}

