/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorResult;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public abstract class AbstractProfileInterceptorResult
extends AbstractIdentifiableInitializableComponent
implements ProfileInterceptorResult {
    @Nonnull
    @NotEmpty
    private String storageContext;
    @Nonnull
    @NotEmpty
    private String storageKey;
    @Nonnull
    @NotEmpty
    private String storageValue;
    @Nullable
    private Instant storageExpiration;

    public AbstractProfileInterceptorResult(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Instant expiration) {
        this.storageContext = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)context), (String)"Storage context cannot be null nor empty");
        this.storageKey = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)key), (String)"Storage key cannot be null nor empty");
        this.storageValue = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)value), (String)"Storage value cannot be null nor empty");
        if (expiration != null) {
            Constraint.isGreaterThan((long)0L, (long)expiration.toEpochMilli(), (String)"Storage expiration must be greater than 0");
            this.storageExpiration = expiration;
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getStorageContext() {
        return this.storageContext;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getStorageKey() {
        return this.storageKey;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getStorageValue() {
        return this.storageValue;
    }

    @Override
    @Nullable
    public Instant getStorageExpiration() {
        return this.storageExpiration;
    }
}

