/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.criterion.HttpServletRequestCriterion;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulateSessionContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateSessionContext.class);
    @NonnullAfterInit
    private SessionResolver sessionResolver;
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextCreationStrategy = new ChildContextLookup(SessionContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, CriteriaSet> sessionResolverCriteriaStrategy = prc -> new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()});
    @Nullable
    private Function<ProfileRequestContext, String> addressLookupStrategy;

    public void setSessionResolver(@Nonnull SessionResolver resolver) {
        this.checkSetterPreconditions();
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"SessionResolver cannot be null");
    }

    public void setSessionContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        this.checkSetterPreconditions();
        this.sessionContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext creation strategy cannot be null");
    }

    public void setAddressLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.addressLookupStrategy = strategy;
    }

    public void setSessionResolverCriteriaStrategy(@Nonnull Function<ProfileRequestContext, CriteriaSet> strategy) {
        this.sessionResolverCriteriaStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionResolver CriteriaSet strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!PredicateSupport.isAlwaysFalse((Predicate)this.getActivationCondition()) && this.sessionResolver == null) {
            throw new ComponentInitializationException("SessionResolver cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        IdPSession session = null;
        try {
            SessionContext sessionCtx;
            session = (IdPSession)this.sessionResolver.resolveSingle((Object)this.sessionResolverCriteriaStrategy.apply(profileRequestContext));
            if (session == null) {
                this.log.debug("{} No session found for client", (Object)this.getLogPrefix());
                return;
            }
            if (!session.checkTimeout()) {
                this.log.info("{} Session {} no longer valid due to inactivity", (Object)this.getLogPrefix(), (Object)session.getId());
                return;
            }
            String addr = null;
            if (this.addressLookupStrategy != null) {
                addr = this.addressLookupStrategy.apply(profileRequestContext);
            } else {
                HttpServletRequest request = this.getHttpServletRequest();
                String string = addr = request != null ? HttpServletSupport.getRemoteAddr((ServletRequest)request) : null;
            }
            if (addr != null) {
                if (!session.checkAddress(addr)) {
                    return;
                }
            } else {
                this.log.info("{} No client address available, skipping address check for session {}", (Object)this.getLogPrefix(), (Object)session.getId());
            }
            if ((sessionCtx = this.sessionContextCreationStrategy.apply(profileRequestContext)) == null) {
                this.log.error("{} Unable to create or locate SessionContext", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return;
            }
            sessionCtx.setIdPSession(session);
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving a session for the active client", (Object)this.getLogPrefix(), (Object)e);
        }
        catch (SessionException e) {
            this.log.error("{} Error during timeout or address checking for session {}", new Object[]{this.getLogPrefix(), session.getId(), e});
        }
    }
}

