/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.security.trust;

import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.custom.AbstractCustomBeanDefinitionParser;
import net.shibboleth.shared.xml.ElementSupport;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractPKIXValidationInfoParser
extends AbstractCustomBeanDefinitionParser {
    @Nonnull
    private static final QName CERTIFICATE = new QName("urn:mace:shibboleth:2.0:security", "Certificate");
    @Nonnull
    private static final QName CRL = new QName("urn:mace:shibboleth:2.0:security", "CRL");

    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        builder.addPropertyValue("configDescription", (Object)parserContext.getReaderContext().getResource().getDescription());
        if (element.hasAttributeNS(null, "verifyDepth")) {
            builder.addPropertyValue("verifyDepth", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "verifyDepth")));
        }
        List certificates = ElementSupport.getChildElements((Node)element, (QName)CERTIFICATE);
        ManagedList certStrings = new ManagedList(certificates.size());
        for (Element cert : certificates) {
            certStrings.add(cert.getTextContent());
        }
        builder.addPropertyValue("certificates", (Object)certStrings);
        List crls = ElementSupport.getChildElements((Node)element, (QName)CRL);
        ManagedList crlStrings = new ManagedList(certificates.size());
        for (Element crl : crls) {
            crlStrings.add(crl.getTextContent());
        }
        builder.addPropertyValue("CRLs", (Object)crlStrings);
    }
}

