/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring;

import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ScriptTypeBeanParser {
    private ScriptTypeBeanParser() {
    }

    @Nonnull
    public static BeanDefinitionBuilder parseScriptType(@Nonnull Class<?> type, @Nonnull Element element) {
        String customRef;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(type);
        if (element.hasAttributeNS(null, "language")) {
            String scriptLanguage = StringSupport.trimOrNull((String)element.getAttributeNS(null, "language"));
            builder.addConstructorArgValue((Object)scriptLanguage);
        }
        if (null != (customRef = StringSupport.trimOrNull((String)element.getAttributeNS(null, "customObjectRef")))) {
            builder.addPropertyReference("customObject", customRef);
        }
        Element scriptChild = ElementSupport.getFirstChildElement((Node)element);
        assert (scriptChild != null);
        builder.addConstructorArgValue((Object)ElementSupport.getElementContentAsString((Element)scriptChild));
        if (ElementSupport.isElementNamed((Element)scriptChild, (String)element.getNamespaceURI(), (String)"Script")) {
            builder.setFactoryMethod("inlineScript");
        } else if (ElementSupport.isElementNamed((Element)scriptChild, (String)element.getNamespaceURI(), (String)"ScriptFile")) {
            builder.setFactoryMethod("resourceScript");
        }
        return builder;
    }
}

