/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.plugin;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.module.Module;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;

public interface Plugin<T extends Module> {
    @Nonnull
    @NotEmpty
    public String getPluginId();

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<URL> getUpdateURLs() throws IOException;

    @Nonnull
    @Unmodifiable
    @NotLive
    default public List<URL> getModuleInfoSources() throws IOException {
        return CollectionSupport.emptyList();
    }

    @Nonnegative
    public int getMajorVersion();

    @Nonnegative
    public int getMinorVersion();

    @Nonnegative
    public int getPatchVersion();

    @Nullable
    public String getLicenseFileLocation();

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<String> getRequiredModules();

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<T> getEnableOnInstall();

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<T> getDisableOnRemoval();

    @Nonnull
    @Unmodifiable
    @NotLive
    default public Collection<Package> getPackages() {
        return CollectionSupport.emptySet();
    }

    public static interface Package {
        @Nonnull
        @Unmodifiable
        @NotLive
        public String getSourceName();

        @Nonnull
        @Unmodifiable
        @NotLive
        public String getDestinationName();

        public boolean isWindows();

        public boolean isNonWindows();

        public boolean isStripTopLevelDir();
    }
}

