/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.navigate;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;

public class ScriptedContextLookupFunction<T extends BaseContext>
extends AbstractScriptEvaluator
implements ContextDataLookupFunction<T, Object> {
    @Nonnull
    private final Class<T> inputClass;

    protected ScriptedContextLookupFunction(@Nonnull Class<T> inClass, @Nonnull EvaluableScript theScript, @Nullable String extraInfo) {
        super(theScript);
        this.inputClass = (Class)Constraint.isNotNull(inClass, (String)"Supplied inputClass cannot be null");
        this.setLogPrefix("Scripted Function from " + extraInfo + ":");
    }

    protected ScriptedContextLookupFunction(@Nonnull Class<T> inClass, @Nonnull EvaluableScript theScript) {
        super(theScript);
        this.inputClass = (Class)Constraint.isNotNull(inClass, (String)"Supplied inputClass cannot be null");
        this.setLogPrefix("Anonymous Scripted Function:");
    }

    protected ScriptedContextLookupFunction(@Nonnull Class<T> inClass, @Nonnull EvaluableScript theScript, @Nullable String extraInfo, @Nullable Class<?> outputType) {
        this(inClass, theScript, extraInfo);
        this.setOutputType(outputType);
    }

    @Nullable
    public Object getCustomObject() {
        return super.getCustomObject();
    }

    public Object apply(@Nullable T context) {
        if (null != context && !this.inputClass.isInstance(context)) {
            throw new ClassCastException(this.getLogPrefix() + " Input was type " + String.valueOf(context.getClass()) + " which is not an instance of " + String.valueOf(this.inputClass));
        }
        return this.evaluate(new Object[]{context});
    }

    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("profileContext", input != null ? input[0] : null, 100);
        scriptContext.setAttribute("input", input != null ? input[0] : null, 100);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedContextLookupFunction.resourceScript(engineName, resource, null);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="resource") Resource resource, @Nullable @ParameterName(name="outputType") Class<?> outputType) throws ScriptException, IOException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(resource);
        script.initialize();
        return new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, resource.getDescription(), outputType);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(@Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedContextLookupFunction.resourceScript("JavaScript", resource, null);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<ProfileRequestContext> resourceScript(@Nonnull @ParameterName(name="resource") Resource resource, @Nullable @ParameterName(name="outputType") Class<?> outputType) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedContextLookupFunction.resourceScript("JavaScript", resource, outputType);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, "Inline");
    }

    @Nonnull
    public static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource, @Nullable @ParameterName(name="outputType") Class<?> outputType) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedContextLookupFunction<ProfileRequestContext>(ProfileRequestContext.class, script, "Inline", outputType);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        return ScriptedContextLookupFunction.inlineScript("JavaScript", scriptSource);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<ProfileRequestContext> inlineScript(@Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource, @Nullable @ParameterName(name="outputType") Class<?> outputType) throws ScriptException, ComponentInitializationException {
        return ScriptedContextLookupFunction.inlineScript("JavaScript", scriptSource, outputType);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<MessageContext> resourceMessageContextScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedContextLookupFunction.resourceMessageContextScript(engineName, resource, null);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<MessageContext> resourceMessageContextScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="resource") Resource resource, @Nullable @ParameterName(name="outputType") Class<?> outputType) throws ScriptException, IOException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(resource);
        script.initialize();
        return new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, resource.getDescription(), outputType);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<MessageContext> resourceMessageContextScript(@Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedContextLookupFunction.resourceMessageContextScript("JavaScript", resource, null);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<MessageContext> resourceMessageContextScript(@Nonnull @ParameterName(name="resource") Resource resource, @Nullable @ParameterName(name="outputType") Class<?> outputType) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedContextLookupFunction.resourceMessageContextScript("JavaScript", resource, outputType);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, "Inline");
    }

    @Nonnull
    public static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource, @Nullable @ParameterName(name="outputType") Class<?> outputType) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedContextLookupFunction<MessageContext>(MessageContext.class, script, "Inline", outputType);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        return ScriptedContextLookupFunction.inlineMessageContextScript("JavaScript", scriptSource);
    }

    @Nonnull
    public static ScriptedContextLookupFunction<MessageContext> inlineMessageContextScript(@Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource, @Nullable @ParameterName(name="outputType") Class<?> outputType) throws ScriptException, ComponentInitializationException {
        return ScriptedContextLookupFunction.inlineMessageContextScript("JavaScript", scriptSource, outputType);
    }
}

