/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.logic;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractAttributePredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAttributePredicate.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    private boolean useUnfilteredAttributes = true;

    @Nonnull
    public Function<ProfileRequestContext, AttributeContext> getAttributeContextLookupStrategy() {
        return this.attributeContextLookupStrategy;
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public boolean isUseUnfilteredAttributes() {
        return this.useUnfilteredAttributes;
    }

    public void setUseUnfilteredAttributes(boolean flag) {
        this.useUnfilteredAttributes = flag;
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        Map attributes;
        AttributeContext attributeCtx = this.attributeContextLookupStrategy.apply(input);
        if (attributeCtx == null) {
            this.log.warn("No AttributeContext located for evaluation");
            return this.allowNullAttributeContext();
        }
        Map map = attributes = this.useUnfilteredAttributes ? attributeCtx.getUnfilteredIdPAttributes() : attributeCtx.getIdPAttributes();
        if (this.hasMatch(attributes)) {
            this.log.debug("Context satisfied requirements");
            return true;
        }
        return false;
    }

    protected boolean allowNullAttributeContext() {
        return false;
    }

    protected abstract boolean hasMatch(@Nonnull Map<String, IdPAttribute> var1);
}

