/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.config.navigate;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.config.navigate.AbstractDefaultSecurityConfigurationLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.Live;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.config.XMLSecurityConfiguration;

public class EncryptionConfigurationLookupFunction
extends AbstractDefaultSecurityConfigurationLookupFunction<List<EncryptionConfiguration>> {
    @Nullable
    @Live
    public List<EncryptionConfiguration> apply(@Nullable ProfileRequestContext input) {
        ArrayList<EncryptionConfiguration> configs = new ArrayList<EncryptionConfiguration>();
        RelyingPartyContext rpc = this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            SecurityConfiguration defaultConfig;
            XMLSecurityConfiguration xsc;
            SecurityConfiguration sc;
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc != null && (sc = pc.getSecurityConfiguration(input)) instanceof XMLSecurityConfiguration && (xsc = (XMLSecurityConfiguration)sc).getEncryptionConfiguration() != null) {
                configs.add(xsc.getEncryptionConfiguration());
            }
            if ((defaultConfig = this.getDefaultSecurityConfiguration(rpc.getConfiguration(), input)) instanceof XMLSecurityConfiguration && (xsc = (XMLSecurityConfiguration)defaultConfig).getEncryptionConfiguration() != null) {
                configs.add(xsc.getEncryptionConfiguration());
            }
        }
        configs.add(SecurityConfigurationSupport.getGlobalEncryptionConfiguration());
        return configs;
    }
}

