/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.protocol;

import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.protocol.ProtocolParam;
import net.shibboleth.idp.cas.protocol.SamlParam;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.URLBuilder;

public class ServiceTicketResponse {
    @Nonnull
    private final String serviceURL;
    @Nonnull
    private final String serviceTicket;
    private boolean saml;

    public ServiceTicketResponse(@Nonnull String service, @Nonnull String ticket) {
        this.serviceURL = (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null");
        this.serviceTicket = (String)Constraint.isNotNull((Object)ticket, (String)"Ticket cannot be null");
    }

    @Nonnull
    public String getService() {
        return this.serviceURL;
    }

    @Nonnull
    public String getTicket() {
        return this.serviceTicket;
    }

    public boolean isSaml() {
        return this.saml;
    }

    public void setSaml(boolean flag) {
        this.saml = flag;
    }

    @Nonnull
    public String getTicketParameterName() {
        String result = this.saml ? SamlParam.SAMLart.name() : ProtocolParam.Ticket.id();
        assert (result != null);
        return result;
    }

    @Nonnull
    public String getRedirectUrl() {
        try {
            URLBuilder builder = new URLBuilder(this.serviceURL);
            builder.getQueryParams().add(new Pair((Object)this.getTicketParameterName(), (Object)this.serviceTicket));
            return builder.buildURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

