/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509TrustManager;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.httpclient.TLSSocketFactoryBuilder;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.slf4j.Logger;

public final class HttpClientSupport {
    @Nonnull
    @NotEmpty
    public static final String CONTEXT_KEY_DYNAMIC_CONTEXT_HANDLERS = "java-support.DynamicContextHandlers";
    @Nonnull
    @NotEmpty
    public static final String CONTEXT_KEY_REQUEST_TIMEOUT = "java-support.RequestTimeout";

    private HttpClientSupport() {
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildStrictTLSSocketFactory() {
        return new TLSSocketFactoryBuilder().setHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier()).build();
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildNoTrustTLSSocketFactory() {
        return new TLSSocketFactoryBuilder().setTrustManagers(CollectionSupport.singletonList((Object)HttpClientSupport.buildNoTrustX509TrustManager())).setHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
    }

    @Nonnull
    public static X509TrustManager buildNoTrustX509TrustManager() {
        return new X509TrustManager(){
            private Logger log = LoggerFactory.getLogger((String)(HttpClientSupport.class.getName() + ".NoTrustX509TrustManager"));

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                this.log.trace("In getAcceptedIssuers");
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                this.log.trace("In checkServerTrusted");
                if (chain != null) {
                    this.log.trace("Cert chain length: {}", (Object)chain.length);
                    for (X509Certificate cert : chain) {
                        this.log.trace("Cert key type: {}, subject: {}", (Object)cert.getPublicKey().getAlgorithm(), (Object)cert.getSubjectX500Principal().getName());
                    }
                } else {
                    this.log.trace("Cert chain was null");
                }
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                this.log.trace("In checkClientTrusted");
            }
        };
    }

    @Nonnull
    public static HttpClientContext buildHttpClientContext() {
        return HttpClientContext.create();
    }

    @Nonnull
    @Live
    public static List<HttpClientContextHandler> getDynamicContextHandlerList(@Nonnull HttpClientContext context) {
        Constraint.isNotNull((Object)context, (String)"HttpClientContext was null");
        ArrayList handlers = (ArrayList)context.getAttribute(CONTEXT_KEY_DYNAMIC_CONTEXT_HANDLERS, List.class);
        if (handlers == null) {
            handlers = new ArrayList();
            context.setAttribute(CONTEXT_KEY_DYNAMIC_CONTEXT_HANDLERS, handlers);
        }
        return handlers;
    }

    public static void addDynamicContextHandlerFirst(@Nonnull HttpClientContext context, @Nonnull HttpClientContextHandler handler) {
        HttpClientSupport.addDynamicContextHandlerFirst(context, handler, false);
    }

    public static void addDynamicContextHandlerFirst(@Nonnull HttpClientContext context, @Nonnull HttpClientContextHandler handler, boolean uniqueType) {
        Constraint.isNotNull((Object)handler, (String)"HttpClientContextHandler was null");
        List<HttpClientContextHandler> list = HttpClientSupport.getDynamicContextHandlerList(context);
        if (list.contains(handler) || uniqueType && list.stream().anyMatch(h -> handler.getClass().equals(h.getClass()))) {
            return;
        }
        list.add(0, handler);
    }

    public static void addDynamicContextHandlerLast(@Nonnull HttpClientContext context, @Nonnull HttpClientContextHandler handler) {
        HttpClientSupport.addDynamicContextHandlerLast(context, handler, false);
    }

    public static void addDynamicContextHandlerLast(@Nonnull HttpClientContext context, @Nonnull HttpClientContextHandler handler, boolean uniqueType) {
        Constraint.isNotNull((Object)handler, (String)"HttpClientContextHandler was null");
        List<HttpClientContextHandler> list = HttpClientSupport.getDynamicContextHandlerList(context);
        if (list.contains(handler) || uniqueType && list.stream().anyMatch(h -> handler.getClass().equals(h.getClass()))) {
            return;
        }
        list.add(handler);
    }

    public static void addRequestTimeout(@Nonnull HttpClientContext context, @Nullable Duration timeout) {
        Constraint.isNotNull((Object)context, (String)"HttpClientContext was null");
        context.setAttribute(CONTEXT_KEY_REQUEST_TIMEOUT, (Object)timeout);
    }

    @Nullable
    public static String toString(@Nonnull HttpEntity entity, @Nullable Charset defaultCharset, int maxLength) throws IOException, ParseException {
        try (InputStream instream = entity.getContent();){
            String string;
            if (instream == null) {
                String string2 = null;
                return string2;
            }
            if (entity.getContentLength() > (long)maxLength || entity.getContentLength() > Integer.MAX_VALUE) {
                throw new IOException("HTTP entity size exceeded limit");
            }
            int i = (int)entity.getContentLength();
            if (i < 0) {
                i = 4096;
            }
            Charset charset = null;
            try {
                ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
                if (contentType != null) {
                    charset = contentType.getCharset();
                }
            }
            catch (UnsupportedCharsetException ex) {
                throw new UnsupportedEncodingException(ex.getMessage());
            }
            if (charset == null) {
                charset = defaultCharset;
            }
            if (charset == null) {
                charset = Charset.forName("ISO-8859-1");
            }
            try (InputStreamReader reader = new InputStreamReader(instream, charset);){
                int l;
                CharArrayBuffer buffer = new CharArrayBuffer(i);
                char[] tmp = new char[1024];
                int size = 0;
                while ((l = reader.read(tmp)) != -1) {
                    if ((size += l) > maxLength) {
                        throw new IOException("HTTP entity size exceeded limit");
                    }
                    buffer.append(tmp, 0, l);
                }
                string = buffer.toString();
            }
            return string;
        }
    }

    @Nullable
    public static String toString(@Nonnull HttpEntity entity, @Nullable String defaultCharset, int maxLength) throws IOException, ParseException {
        return HttpClientSupport.toString(entity, defaultCharset != null ? Charset.forName(defaultCharset) : null, maxLength);
    }

    @Nullable
    public static String toString(@Nonnull HttpEntity entity, int maxLength) throws IOException, ParseException {
        return HttpClientSupport.toString(entity, (Charset)null, maxLength);
    }
}

