/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.nameid.transcoding;

import com.google.common.base.Strings;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAMLAttributeTranscoder;
import net.shibboleth.idp.saml.saml2.nameid.transcoding.SAML2NameIDTranscoder;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.NameID;

public abstract class AbstractSAML2NameIDTranscoder<EncodedType extends IdPAttributeValue>
extends AbstractSAMLAttributeTranscoder<NameID, EncodedType>
implements SAML2NameIDTranscoder<EncodedType> {
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> serviceProviderNameLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> identityProviderNameLookupStrategy;

    public void setServiceProviderNameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.serviceProviderNameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SP name lookup strategy cannot be null");
    }

    public void setIdentityProviderNameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.identityProviderNameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdP name lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.serviceProviderNameLookupStrategy == null || this.identityProviderNameLookupStrategy == null) {
            throw new ComponentInitializationException("IdP/SP name lookup strategies cannot be null");
        }
    }

    @Nonnull
    public Class<NameID> getEncodedType() {
        return NameID.class;
    }

    @Nullable
    public String getEncodedName(@Nonnull TranscodingRule rule) {
        String format = (String)rule.getOrDefault("saml2.nameFormat", String.class, (Object)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        return "SAML2:NameID:" + format;
    }

    @Override
    @Nonnull
    protected NameID buildAttribute(@Nullable ProfileRequestContext profileRequestContext, @Nullable IdPAttribute attribute, @Nonnull Class<? extends NameID> to, @Nonnull TranscodingRule rule, @Nonnull List<XMLObject> attributeValues) throws AttributeEncodingException {
        throw new AttributeEncodingException("NameID transcoders do not support encoding");
    }

    @Override
    @Nonnull
    protected IdPAttribute buildIdPAttribute(@Nullable ProfileRequestContext profileRequestContext, @Nonnull NameID nameID, @Nonnull TranscodingRule rule, @Nonnull List<IdPAttributeValue> attributeValues) throws AttributeDecodingException {
        if (nameID.getValue() != null && attributeValues.isEmpty()) {
            throw new AttributeDecodingException("Failed to decode value for NameID with Format " + nameID.getFormat());
        }
        String id = (String)rule.get("id", String.class);
        if (Strings.isNullOrEmpty((String)id)) {
            throw new AttributeDecodingException("Required transcoder property 'id' not found");
        }
        assert (id != null);
        IdPAttribute idpAttribute = new IdPAttribute(id);
        idpAttribute.setValues(attributeValues);
        return idpAttribute;
    }

    @Override
    @Nonnull
    protected Iterable<XMLObject> getValues(@Nonnull NameID input) {
        return input.getValue() != null ? CollectionSupport.singletonList((Object)input) : CollectionSupport.emptyList();
    }

    @Nonnull
    protected String getNameQualifier(@Nullable ProfileRequestContext profileRequestContext, @Nonnull NameID input, boolean useDefaultQualifier) {
        String qual = input.getNameQualifier();
        if (qual != null) {
            return qual;
        }
        if (useDefaultQualifier && (qual = this.identityProviderNameLookupStrategy.apply(profileRequestContext)) != null) {
            return qual;
        }
        return "";
    }

    @Nonnull
    protected String getSPNameQualifier(@Nullable ProfileRequestContext profileRequestContext, @Nonnull NameID input, boolean useDefaultQualifier) {
        String qual = input.getSPNameQualifier();
        if (qual != null) {
            return qual;
        }
        if (useDefaultQualifier && (qual = this.serviceProviderNameLookupStrategy.apply(profileRequestContext)) != null) {
            return qual;
        }
        return "";
    }

    public static class NamingFunction
    implements Function<NameID, String> {
        @Override
        @Nullable
        public String apply(@Nullable NameID input) {
            if (input == null) {
                return null;
            }
            String format = input.getFormat();
            if (format == null) {
                format = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("SAML2:NameID:").append(format);
            return builder.toString();
        }
    }
}

