/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.service.security.impl;

import jakarta.servlet.ServletRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.AccessControl;
import net.shibboleth.shared.security.AccessControlService;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.slf4j.Logger;

public class DelegatingAccessControlService
extends AbstractIdentifiableInitializableComponent
implements AccessControlService {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DelegatingAccessControlService.class);
    @Nonnull
    private final ReloadableService<AccessControlService> service;

    public DelegatingAccessControlService(@Nonnull @ParameterName(name="acService") ReloadableService<AccessControlService> acService) {
        this.service = (ReloadableService)Constraint.isNotNull(acService, (String)"AccessControlService cannot be null");
    }

    @Nonnull
    public AccessControl getInstance(@Nonnull String name) {
        this.checkComponentActive();
        ServiceableComponent<AccessControlService> component = this.service.getServiceableComponent();
        try {
            AccessControl accessControl = component.getComponent().getInstance(name);
            if (component != null) {
                component.close();
            }
            return accessControl;
        }
        catch (Throwable throwable) {
            try {
                if (component != null) {
                    try {
                        component.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ServiceException e) {
                this.log.error("AccessControlService '{}': Invalid configuration", (Object)this.getId(), (Object)e);
                return new AccessControl(){

                    public boolean checkAccess(@Nonnull ServletRequest request, @Nullable String operation, @Nullable String resource) {
                        return false;
                    }
                };
            }
        }
    }
}

