/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import com.google.common.base.StandardSystemProperty;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.module.IdPModule;
import net.shibboleth.idp.plugin.IdPPlugin;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;

public final class LogImplementationDetails
extends ApplicationObjectSupport {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LogImplementationDetails.class);

    protected boolean isContextRequired() {
        return true;
    }

    protected void initApplicationContext(@Nonnull ApplicationContext context) throws BeansException {
        String autoSearch;
        List plugins;
        this.log.info("Shibboleth IdP Version {}", (Object)Version.getVersion());
        this.log.info("Java version='{}' vendor='{}'", (Object)StandardSystemProperty.JAVA_VERSION.value(), (Object)StandardSystemProperty.JAVA_VENDOR.value());
        if (this.log.isDebugEnabled()) {
            for (StandardSystemProperty standardSystemProperty : StandardSystemProperty.values()) {
                this.log.debug("{}", (Object)standardSystemProperty);
            }
        }
        if ((plugins = ServiceLoader.load(IdPPlugin.class).stream().map(e -> (IdPPlugin)e.get()).collect(Collectors.toList())).isEmpty()) {
            this.log.info("No Plugins Loaded");
        } else {
            this.log.info("Plugins:");
            for (IdPPlugin idpPlugin : plugins) {
                this.log.info("\t\t{} : v{}.{}.{}", new Object[]{idpPlugin.getPluginId(), idpPlugin.getMajorVersion(), idpPlugin.getMinorVersion(), idpPlugin.getPatchVersion()});
            }
        }
        String idpHomeLocation = context.getEnvironment().getProperty("idp.home");
        if (idpHomeLocation != null) {
            ModuleContext moduleContext = new ModuleContext(idpHomeLocation);
            List modules = ServiceLoader.load(IdPModule.class).stream().map(e -> (IdPModule)e.get()).filter(f -> f.isEnabled(moduleContext)).collect(Collectors.toList());
            if (modules.isEmpty()) {
                this.log.info("No Modules Enabled");
            } else {
                this.log.info("Enabled Modules:");
                for (IdPModule module : modules) {
                    this.log.info("\t\t{}-{}", (Object)module.getId(), (Object)module.getName(moduleContext));
                    if (!this.log.isDebugEnabled()) continue;
                    String plugin = module.getOwnerId();
                    if (plugin != null) {
                        this.log.debug("\t\t\tPlugin: {}", (Object)plugin);
                    }
                    this.log.debug("\t\t\t{}", (Object)module.getDescription(moduleContext));
                }
            }
        } else {
            this.log.warn("Could not enumerate Modules");
        }
        String duplicateProperties = context.getEnvironment().getProperty("idp.duplicateProperties");
        if (duplicateProperties != null && !duplicateProperties.isBlank()) {
            this.log.warn("Duplicate properties were detected: {}", (Object)duplicateProperties);
        }
        if (!Boolean.valueOf(autoSearch = context.getEnvironment().getProperty("idp.searchForProperties")).booleanValue()) {
            this.log.warn("{} is false or unset, plugin use may require additional changes to add new property sources", (Object)"idp.searchForProperties");
        }
    }
}

