/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.admin.impl.IdPInfo;
import net.shibboleth.idp.plugin.IdPPlugin;
import net.shibboleth.idp.plugin.impl.PluginInfo;
import net.shibboleth.profile.installablecomponent.InstallableComponentInfo;
import net.shibboleth.profile.installablecomponent.InstallableComponentSupport;
import net.shibboleth.profile.installablecomponent.InstallableComponentVersion;
import net.shibboleth.profile.plugin.Plugin;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.NullableElements;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.jetbrains.annotations.NotNull;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;

public class InstallableComponentGaugeSet
extends AbstractIdentifiableInitializableComponent
implements MetricSet,
MetricFilter {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.installation";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InstallableComponentGaugeSet.class);
    @Nonnull
    private final Map<String, Metric> gauges = new HashMap<String, Metric>();
    @Nonnull
    private List<URL> idpUpdateUrls = CollectionSupport.emptyList();
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters securityParams;
    @NonnullAfterInit
    private InstallableComponentVersion idpVersion;
    private boolean updateCheckEnabled;

    public void setIdpUpdateUrls(@Nonnull List<URL> urls) {
        this.idpUpdateUrls = urls;
    }

    public void setSecurityParams(@Nullable HttpClientSecurityParameters params) {
        this.securityParams = params;
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setUpdateCheckEnabled(boolean what) {
        this.updateCheckEnabled = what;
    }

    @Nonnull
    InstallableComponentVersion getIdPVersion() {
        this.checkComponentActive();
        assert (this.idpVersion != null);
        return this.idpVersion;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    private Map<String, InstallableComponentVersion> getPluginList() {
        HashMap<String, InstallableComponentVersion> result = new HashMap<String, InstallableComponentVersion>();
        for (IdPPlugin plugin : ServiceLoader.load(IdPPlugin.class)) {
            result.put(plugin.getPluginId(), new InstallableComponentVersion((Plugin)plugin));
        }
        return CollectionSupport.copyToMap(result);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    private Map<String, InstallableComponentDetails> getPluginDetails() {
        HashMap<URL, Properties> pluginInfoCache = new HashMap<URL, Properties>();
        HashMap<String, InstallableComponentDetails> result = new HashMap<String, InstallableComponentDetails>();
        for (IdPPlugin plugin : ServiceLoader.load(IdPPlugin.class)) {
            assert (plugin != null);
            Properties properties = this.lookupIdPProperties(plugin, pluginInfoCache);
            if (properties == null) {
                this.log.warn("Could not locate plugin version information");
                continue;
            }
            PluginInfo info = new PluginInfo(plugin.getPluginId(), properties);
            InstallableComponentVersion pluginVersion = new InstallableComponentVersion((Plugin)plugin);
            InstallableComponentInfo.VersionInfo verInfo = (InstallableComponentInfo.VersionInfo)info.getAvailableVersions().get(pluginVersion);
            if (verInfo == null) {
                this.log.warn("Could not locate plugin version information");
                continue;
            }
            InstallableComponentVersion newPluginVersion = InstallableComponentSupport.getBestVersion((InstallableComponentVersion)this.getIdPVersion(), (InstallableComponentVersion)pluginVersion, (InstallableComponentInfo)info);
            result.put(plugin.getPluginId(), new InstallableComponentDetails(verInfo.getSupportLevel(), newPluginVersion));
        }
        return CollectionSupport.copyToMap(result);
    }

    @Nullable
    private Properties lookupIdPProperties(@NotNull IdPPlugin plugin, @NullableElements Map<URL, Properties> pluginInfoCache) {
        List urls;
        try {
            urls = plugin.getUpdateURLs();
        }
        catch (IOException e) {
            this.log.error("Could not locate plugin {} update URLs", (Object)plugin.getPluginId(), (Object)e);
            return null;
        }
        for (URL url : urls) {
            if (!pluginInfoCache.containsKey(url)) continue;
            return pluginInfoCache.get(url);
        }
        assert (this.httpClient != null);
        Properties result = InstallableComponentSupport.loadInfo((List)urls, (HttpClient)this.httpClient, (HttpClientSecurityParameters)this.securityParams);
        for (URL url : urls) {
            pluginInfoCache.put(url, result);
        }
        return result;
    }

    @Nullable
    private InstallableComponentDetails getIdPDetails() {
        try {
            assert (this.httpClient != null);
            Properties properties = InstallableComponentSupport.loadInfo(this.idpUpdateUrls, (HttpClient)this.httpClient, (HttpClientSecurityParameters)this.securityParams);
            if (properties == null) {
                this.log.warn("Could not locate IdP update information");
                return null;
            }
            IdPInfo info = new IdPInfo(properties);
            InstallableComponentInfo.VersionInfo verInfo = (InstallableComponentInfo.VersionInfo)info.getAvailableVersions().get(this.getIdPVersion());
            if (verInfo == null) {
                this.log.warn("Could not locate IdP version information");
                return null;
            }
            InstallableComponentVersion newIdPVersion = InstallableComponentSupport.getBestVersion((InstallableComponentVersion)this.getIdPVersion(), (InstallableComponentVersion)this.getIdPVersion(), (InstallableComponentInfo)info);
            return new InstallableComponentDetails(verInfo.getSupportLevel(), newIdPVersion);
        }
        catch (Throwable t) {
            this.log.error("Check for IdP update status failed unexpectedly", t);
            return null;
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException("HttpClient was null");
        }
        String idpVersionStr = Version.getVersion();
        if (idpVersionStr == null) {
            this.log.warn("Could not find current IdP Version (likely operating inside IDE), assuming V5.1.2");
            this.idpVersion = new InstallableComponentVersion(5, 1, 2);
        } else {
            this.idpVersion = new InstallableComponentVersion(idpVersionStr);
        }
        this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{"plugins", "list"}), (Metric)new Gauge<Map<String, InstallableComponentVersion>>(){

            public Map<String, InstallableComponentVersion> getValue() {
                return InstallableComponentGaugeSet.this.getPluginList();
            }
        });
        if (this.updateCheckEnabled) {
            this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{"plugins", "details"}), (Metric)new Gauge<Map<String, InstallableComponentDetails>>(){

                public Map<String, InstallableComponentDetails> getValue() {
                    return InstallableComponentGaugeSet.this.getPluginDetails();
                }
            });
            this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{"idp", "details"}), (Metric)new Gauge<InstallableComponentDetails>(){

                public InstallableComponentDetails getValue() {
                    return InstallableComponentGaugeSet.this.getIdPDetails();
                }
            });
        }
    }

    public Map<String, Metric> getMetrics() {
        return this.gauges;
    }

    public boolean matches(String name, Metric metric) {
        return this.gauges.containsKey(name);
    }

    record InstallableComponentDetails(@Nonnull @NotEmpty InstallableComponentSupport.SupportLevel supportedState, @Nullable InstallableComponentVersion updateVersion) {
    }
}

