/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

@ThreadSafe
public class DumpConfigRequest {
    @Nonnull
    @NotEmpty
    private final String profileId;
    @Nonnull
    @NotEmpty
    private final String protocolId;
    @Nonnull
    @NotEmpty
    private final String requesterId;

    public DumpConfigRequest(@Nonnull String profile, @Nonnull String protocol, @Nonnull String requester) {
        this.profileId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)profile), (String)"Profile ID cannot be null or empty");
        this.protocolId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)protocol), (String)"Protocol cannot be null or empty");
        this.requesterId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)requester), (String)"Requester name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getProfileId() {
        return this.profileId;
    }

    @Nonnull
    @NotEmpty
    public String getProtocolId() {
        return this.protocolId;
    }

    @Nonnull
    @NotEmpty
    public String getRequesterId() {
        return this.requesterId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("profileId", (Object)this.profileId).add("protocolId", (Object)this.protocolId).add("requesterId", (Object)this.requesterId).toString();
    }
}

