/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.impl;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.NonnullFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;
import net.shibboleth.shared.spring.service.impl.SpringServiceableComponent;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;

public class AttributeResolverServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements NonnullFunction<ApplicationContext, AbstractServiceableComponent<AttributeResolver>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeResolverServiceStrategy.class);
    private boolean stripNulls;

    public boolean isStripNulls() {
        return this.stripNulls;
    }

    public void setStripNulls(boolean doStripNulls) {
        this.stripNulls = doStripNulls;
    }

    @Nonnull
    public AbstractServiceableComponent<AttributeResolver> apply(@Nullable ApplicationContext appContext) {
        if (appContext == null) {
            throw new ServiceException("ApplicationContext was null");
        }
        Collection definitions = appContext.getBeansOfType(AttributeDefinition.class).values();
        Collection connectors = appContext.getBeansOfType(DataConnector.class).values();
        this.log.debug("Creating Attribute Resolver {} with {} Attribute Definition(s) and {} Data Connector(s)", new Object[]{this.getId(), definitions.size(), connectors.size()});
        AttributeResolverImpl resolver = new AttributeResolverImpl();
        resolver.setAttributeDefinitions(definitions);
        resolver.setDataConnectors(connectors);
        resolver.setId(this.ensureId());
        resolver.setStripNulls(Boolean.valueOf(this.isStripNulls()));
        try {
            resolver.initialize();
            SpringServiceableComponent result = new SpringServiceableComponent((Object)resolver);
            result.setApplicationContext(appContext);
            result.setId(this.ensureId());
            result.initialize();
            return result;
        }
        catch (ComponentInitializationException e) {
            throw new ServiceException("Unable to initialize attribute resolver for " + appContext.getDisplayName(), (Exception)((Object)e));
        }
    }
}

