/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.impl.JDBCPairwiseIdStore;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ComputedIdDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.ManagedConnectionParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class StoredIdDataConnectorParser
extends ComputedIdDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "StoredId");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredIdDataConnectorParser.class);

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder, "storedId");
        builder.addPropertyValue("pairwiseIdStore", (Object)this.doJDBCPairwiseIdStore(config, parserContext));
    }

    @Nonnull
    protected BeanDefinition doJDBCPairwiseIdStore(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        Attr retryableErrorsAttr;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JDBCPairwiseIdStore.class);
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        String beanDataSource = ManagedConnectionParser.getBeanDataSourceID(config);
        if (beanDataSource != null) {
            builder.addPropertyReference("dataSource", beanDataSource);
        } else {
            builder.addPropertyValue("dataSource", (Object)this.getv2DataSource(config));
        }
        if (config.hasAttributeNS(null, "queryTimeout")) {
            builder.addPropertyValue("queryTimeout", (Object)config.getAttributeNS(null, "queryTimeout"));
        }
        if (config.hasAttributeNS(null, "transactionRetries")) {
            builder.addPropertyValue("transactionRetries", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "transactionRetries")));
        }
        if (config.hasAttributeNS(null, "tableName")) {
            builder.addPropertyValue("tableName", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "tableName")));
        }
        if (config.hasAttributeNS(null, "failFastInitialize")) {
            builder.addPropertyValue("verifyDatabase", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "failFastInitialize")));
        }
        if ((retryableErrorsAttr = config.getAttributeNodeNS(null, "retryableErrors")) != null) {
            builder.addPropertyValue("retryableErrors", (Object)SpringSupport.getAttributeValueAsList((Attr)retryableErrorsAttr));
        }
        if (config.hasAttributeNS(null, "salt") || config.hasAttributeNS(null, "encodedSalt") || config.hasAttributeNS(null, "saltLookupStrategyRef")) {
            builder.addPropertyValue("initialValueStore", (Object)this.doComputedPairwiseIdStore(config, parserContext));
        }
        return builder.getBeanDefinition();
    }

    protected BeanDefinition getv2DataSource(@Nonnull Element config) {
        this.log.debug("{} Parsing v2 configuration", (Object)this.getLogPrefix());
        ManagedConnectionParser parser = new ManagedConnectionParser(config);
        return parser.createDataSource();
    }
}

