/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.dc.scripted.impl.ScriptedDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.scripted.impl.ScriptedSearchBuilder;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.CacheConfigParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.factory.EvaluableScriptFactoryBean;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScriptedDataConnectorParser
extends AbstractDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "ScriptedDataConnector");
    @Nonnull
    public static final QName SCRIPT_FILE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "ScriptFile");
    @Nonnull
    public static final QName SCRIPT_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "Script");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedDataConnectorParser.class);

    @Nullable
    protected Class<ScriptedDataConnector> getBeanClass(@Nonnull Element element) {
        return ScriptedDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        builder.addAutowiredProperty("scriptContextExtenders");
        BeanDefinitionBuilder scriptBuilder = BeanDefinitionBuilder.genericBeanDefinition(EvaluableScriptFactoryBean.class);
        scriptBuilder.addPropertyValue("sourceId", (Object)this.getLogPrefix());
        if (config.hasAttributeNS(null, "language")) {
            String scriptLanguage = StringSupport.trimOrNull((String)config.getAttributeNS(null, "language"));
            this.log.debug("{} Scripting language: {}", (Object)this.getLogPrefix(), (Object)scriptLanguage);
            scriptBuilder.addPropertyValue("engineName", (Object)scriptLanguage);
        }
        List scriptElem = ElementSupport.getChildElements((Node)config, (QName)SCRIPT_ELEMENT_NAME);
        List scriptFileElem = ElementSupport.getChildElements((Node)config, (QName)SCRIPT_FILE_ELEMENT_NAME);
        if (scriptElem != null && scriptElem.size() > 0) {
            if (scriptElem.size() > 1) {
                this.log.warn("{} Data connector {}: definition contains more than one  <Script> elements, only the first will be used", (Object)this.getLogPrefix(), (Object)this.getDefinitionId());
            }
            if (scriptFileElem != null && scriptFileElem.size() > 0) {
                this.log.warn("{} Data connector {}: definition contains both <Script> and <ScriptFile> elements, taking the <Script> element", (Object)this.getLogPrefix(), (Object)this.getDefinitionId());
            }
            String script = ((Element)scriptElem.get(0)).getTextContent();
            this.log.debug("{} Script: {}", (Object)this.getLogPrefix(), (Object)script);
            scriptBuilder.addPropertyValue("script", (Object)script);
        } else if (scriptFileElem != null && scriptFileElem.size() > 0) {
            if (scriptFileElem.size() > 1) {
                this.log.warn("{} Data connector {}: definition contains more than one  <ScriptFile> elements, only the first will be used", (Object)this.getLogPrefix(), (Object)this.getDefinitionId());
            }
            String scriptFile = ((Element)scriptFileElem.get(0)).getTextContent();
            this.log.debug("{} Script file: {}", (Object)this.getLogPrefix(), (Object)scriptFile);
            scriptBuilder.addPropertyValue("resource", (Object)scriptFile);
        } else {
            this.log.error("{} No script or script file specified for this data connector", (Object)this.getLogPrefix());
            throw new BeanCreationException("No script or script file specified for this attribute definition");
        }
        String customRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, "customObjectRef"));
        if (null != customRef) {
            builder.addPropertyReference("customObject", customRef);
        }
        builder.addPropertyValue("script", (Object)scriptBuilder.getBeanDefinition());
        BeanDefinitionBuilder searchBuilder = BeanDefinitionBuilder.genericBeanDefinition(ScriptedSearchBuilder.class);
        String velocityEngineRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, "templateEngine"));
        if (null == velocityEngineRef) {
            velocityEngineRef = "shibboleth.VelocityEngine";
        }
        searchBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
        List cacheKeyTemplates = ElementSupport.getChildElements((Node)config, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "CacheKeyTemplate"));
        if (cacheKeyTemplates.size() > 1) {
            this.log.warn("{} A maximum of 1 <CacheKeyTemplate> should be specified; the first one has been used", (Object)this.getLogPrefix());
        }
        if (cacheKeyTemplates.size() > 0) {
            searchBuilder.addPropertyValue("cacheKeyTemplateText", (Object)((Element)cacheKeyTemplates.get(0)).getTextContent());
        }
        builder.addPropertyValue("executableSearchBuilder", (Object)searchBuilder.getBeanDefinition());
        String resultCacheBeanID = CacheConfigParser.getBeanResultCacheID(config);
        if (null != resultCacheBeanID) {
            builder.addPropertyReference("resultsCache", resultCacheBeanID);
        } else {
            builder.addPropertyValue("resultsCache", (Object)new CacheConfigParser(config).createCache());
        }
    }
}

