/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.ad.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.ad.impl.TemplateAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.spring.ad.BaseAttributeDefinitionParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TemplateAttributeDefinitionParser
extends BaseAttributeDefinitionParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "Template");
    @Nonnull
    public static final QName TEMPLATE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "Template");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TemplateAttributeDefinitionParser.class);

    @Nullable
    protected Class<TemplateAttributeDefinition> getBeanClass(@Nullable Element element) {
        return TemplateAttributeDefinition.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        List templateElements = ElementSupport.getChildElements((Node)config, (QName)TEMPLATE_ELEMENT_NAME);
        if (null == templateElements || templateElements.isEmpty()) {
            this.log.error("Missing " + TEMPLATE_ELEMENT_NAME.getLocalPart() + " Element");
        } else {
            if (templateElements.size() > 1) {
                this.log.warn("{} Too many <Template> elements, taking the first");
            }
            String templateText = StringSupport.trimOrNull((String)((Element)templateElements.get(0)).getTextContent());
            this.log.debug("{} Template is '{}'", (Object)this.getLogPrefix(), (Object)templateText);
            builder.addPropertyValue("templateText", (Object)templateText);
        }
        String velocityEngineRef = StringSupport.trimOrNull((String)config.getAttributeNS(null, "velocityEngine"));
        if (null == velocityEngineRef) {
            velocityEngineRef = "shibboleth.VelocityEngine";
        }
        this.log.debug("{} Velocity engine reference '{}'.", (Object)this.getLogPrefix(), (Object)velocityEngineRef);
        builder.addPropertyReference("velocityEngine", velocityEngineRef);
    }
}

