/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.config;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.spring.resource.PreferFileSystemResourceLoader;
import net.shibboleth.shared.spring.resource.ResourceHelper;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.converter.Converter;

public class StringToResourceConverter
implements Converter<String, Resource>,
ApplicationContextAware {
    @Nullable
    private ApplicationContext applicationContext;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StringToResourceConverter.class);

    @Nullable
    public Resource convert(@Nonnull String source) {
        Object loader = this.applicationContext;
        if (loader == null) {
            loader = new PreferFileSystemResourceLoader();
        }
        Resource result = ResourceHelper.of(loader.getResource(source));
        if ((source.endsWith(" ") || this.log.isDebugEnabled()) && !result.exists()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resource at '{}' does not exist", (Object)source);
            }
            if (source.endsWith(" ")) {
                this.log.warn("Missing path '{}' ends with a space, check for stray characters", (Object)source);
            }
        }
        return result;
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) {
        this.applicationContext = context;
    }
}

