/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.dc.ExecutableSearchBuilder;
import net.shibboleth.idp.attribute.resolver.dc.ldap.ExecutableSearchFilter;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapException;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResponse;
import org.ldaptive.handler.SearchResultHandler;
import org.ldaptive.referral.DefaultReferralConnectionFactory;
import org.ldaptive.referral.FollowSearchReferralHandler;
import org.ldaptive.referral.FollowSearchResultReferenceHandler;
import org.ldaptive.referral.ReferralConnectionFactory;
import org.slf4j.Logger;

public abstract class AbstractExecutableSearchFilterBuilder
extends AbstractInitializableComponent
implements ExecutableSearchBuilder<ExecutableSearchFilter> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractExecutableSearchFilterBuilder.class);

    @Nonnull
    protected ExecutableSearchFilter build(final @Nonnull FilterTemplate searchFilter) {
        return new ExecutableSearchFilter(){

            @Override
            @Nullable
            public String getResultCacheKey() {
                return searchFilter.format();
            }

            @Override
            @Nonnull
            public SearchResponse execute(@Nonnull SearchOperation operation, @Nonnull ConnectionFactory factory) throws LdapException {
                SearchOperation op = SearchOperation.copy((SearchOperation)operation);
                if (op.getSearchResultHandlers() != null && op.getSearchResultHandlers().length > 0) {
                    op.setSearchResultHandlers((SearchResultHandler[])Arrays.stream(op.getSearchResultHandlers()).map(h -> {
                        if (h instanceof FollowSearchReferralHandler) {
                            return new FollowSearchReferralHandler((ReferralConnectionFactory)new DefaultReferralConnectionFactory(factory.getConnectionConfig()));
                        }
                        if (h instanceof FollowSearchResultReferenceHandler) {
                            return new FollowSearchResultReferenceHandler((ReferralConnectionFactory)new DefaultReferralConnectionFactory(factory.getConnectionConfig()));
                        }
                        return h;
                    }).toArray(SearchResultHandler[]::new));
                }
                op.setConnectionFactory(factory);
                SearchResponse response = op.execute(searchFilter);
                AbstractExecutableSearchFilterBuilder.this.log.trace("Search returned response {}", (Object)response);
                if (response.getResultCode() != ResultCode.SUCCESS) {
                    throw new LdapException("Search operation did not return success: " + String.valueOf(response.getResultCode()));
                }
                return response;
            }

            @Override
            @Nonnull
            public FilterTemplate getSearchFilter() {
                return searchFilter;
            }

            public String toString() {
                return searchFilter.toString();
            }
        };
    }
}

