/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cas.attribute.Attribute;
import net.shibboleth.idp.cas.protocol.AbstractProtocolResponse;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class TicketValidationResponse
extends AbstractProtocolResponse {
    @Nullable
    private String userName;
    @Nonnull
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    @Nullable
    private String pgtIou;
    @Nonnull
    private final List<String> proxies = new ArrayList<String>();

    @Nullable
    @NotEmpty
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(@Nonnull @NotEmpty String user) {
        this.userName = (String)Constraint.isNotNull((Object)user, (String)"Username cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<Attribute> getAttributes() {
        return CollectionSupport.copyToList(this.attributes);
    }

    public void addAttribute(@Nonnull Attribute attribute) {
        this.attributes.add(attribute);
    }

    @Nullable
    public String getPgtIou() {
        return this.pgtIou;
    }

    public void setPgtIou(@Nullable String iou) {
        this.pgtIou = StringSupport.trimOrNull((String)iou);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getProxies() {
        return CollectionSupport.copyToList(this.proxies);
    }

    public void addProxy(@Nonnull String proxy) {
        this.proxies.add(proxy);
    }
}

