/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport.netty;

import org.ldaptive.transport.DelegateTransportFactory;
import org.ldaptive.transport.ThreadPoolConfig;
import org.ldaptive.transport.Transport;
import org.ldaptive.transport.netty.DefaultNettyTransport;
import org.ldaptive.transport.netty.StatefulNettyTransport;

public class NettyTransportFactory
implements DelegateTransportFactory {
    @Override
    public Transport createTransport(ThreadPoolConfig config) {
        Transport transport = null;
        if (config.getShutdownStrategy() == ThreadPoolConfig.ShutdownStrategy.CONNECTION_CLOSE) {
            transport = new DefaultNettyTransport(config.getThreadPoolName(), config.getIoThreads(), config.getMessageThreads());
        } else if (config.getShutdownStrategy() == ThreadPoolConfig.ShutdownStrategy.CONNECTION_FACTORY_CLOSE) {
            transport = new StatefulNettyTransport(config.getThreadPoolName(), config.getIoThreads(), config.getMessageThreads(), true);
        } else if (config.getShutdownStrategy() == ThreadPoolConfig.ShutdownStrategy.NEVER) {
            transport = new StatefulNettyTransport(config.getThreadPoolName(), config.getIoThreads(), config.getMessageThreads(), false);
        }
        if (transport == null) {
            throw new IllegalArgumentException("Unsupported shutdown strategy: " + String.valueOf((Object)config.getShutdownStrategy()));
        }
        return transport;
    }
}

