/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.sasl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ldaptive.AbstractConfig;
import org.ldaptive.LdapUtils;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.QualityOfProtection;
import org.ldaptive.sasl.SecurityStrength;

public final class SaslConfig
extends AbstractConfig {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private Mechanism mechanism;
    private String authorizationId;
    private Boolean mutualAuthentication;
    private QualityOfProtection[] qualityOfProtection;
    private SecurityStrength[] securityStrength;
    private String saslRealm;

    public Mechanism getMechanism() {
        return this.mechanism;
    }

    public void setMechanism(Mechanism m) {
        this.assertMutable();
        this.logger.trace("setting mechanism: {}", (Object)m);
        this.mechanism = m;
    }

    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public void setAuthorizationId(String id) {
        this.assertMutable();
        this.logger.trace("setting authorizationId: {}", (Object)id);
        this.authorizationId = id;
    }

    public Boolean getMutualAuthentication() {
        return this.mutualAuthentication;
    }

    public void setMutualAuthentication(Boolean b) {
        this.assertMutable();
        this.logger.trace("setting mutualAuthentication: {}", (Object)b);
        this.mutualAuthentication = b;
    }

    public QualityOfProtection[] getQualityOfProtection() {
        return LdapUtils.copyArray(this.qualityOfProtection);
    }

    public void setQualityOfProtection(QualityOfProtection ... qop) {
        this.assertMutable();
        this.checkArrayContainsNull((Object[])qop);
        this.logger.trace("setting qualityOfProtection: {}", (Object)Arrays.toString((Object[])qop));
        this.qualityOfProtection = LdapUtils.copyArray(qop);
    }

    public SecurityStrength[] getSecurityStrength() {
        return LdapUtils.copyArray(this.securityStrength);
    }

    public void setSecurityStrength(SecurityStrength ... ss) {
        this.assertMutable();
        this.checkArrayContainsNull((Object[])ss);
        this.logger.trace("setting securityStrength: {}", (Object)Arrays.toString((Object[])ss));
        this.securityStrength = LdapUtils.copyArray(ss);
    }

    public String getRealm() {
        return this.saslRealm;
    }

    public void setRealm(String realm) {
        this.assertMutable();
        this.logger.trace("setting realm: {}", (Object)realm);
        this.saslRealm = realm;
    }

    public Map<String, ?> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperties(Map<String, ?> props) {
        this.assertMutable();
        this.logger.trace("setting properties: {}", props);
        this.properties.putAll(props);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.assertMutable();
        this.logger.trace("setting property: {}={}", (Object)name, value);
        this.properties.put(name, value);
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::mechanism=" + String.valueOf((Object)this.mechanism) + ", authorizationId=" + this.authorizationId + ", mutualAuthentication=" + this.mutualAuthentication + ", qualityOfProtection=" + Arrays.toString((Object[])this.qualityOfProtection) + ", securityStrength=" + Arrays.toString((Object[])this.securityStrength) + ", realm=" + this.saslRealm + ", properties=" + String.valueOf(this.properties) + "]";
    }

    public static SaslConfig copy(SaslConfig config) {
        SaslConfig copy = new SaslConfig();
        copy.setMechanism(config.getMechanism());
        copy.setAuthorizationId(config.getAuthorizationId());
        copy.setMutualAuthentication(config.getMutualAuthentication());
        copy.setQualityOfProtection(config.getQualityOfProtection());
        copy.setSecurityStrength(config.getSecurityStrength());
        copy.setRealm(config.getRealm());
        copy.setProperties(new HashMap(config.getProperties()));
        return copy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final SaslConfig object = new SaslConfig();

        private Builder() {
        }

        public Builder freeze() {
            this.object.freeze();
            return this;
        }

        public Builder mechanism(Mechanism mechanism) {
            this.object.setMechanism(mechanism);
            return this;
        }

        public Builder authorizationId(String id) {
            this.object.setAuthorizationId(id);
            return this;
        }

        public Builder mutualAuthentication(Boolean b) {
            this.object.setMutualAuthentication(b);
            return this;
        }

        public Builder qualityOfProtection(QualityOfProtection ... protections) {
            this.object.setQualityOfProtection(protections);
            return this;
        }

        public Builder securityStrength(SecurityStrength ... strengths) {
            this.object.setSecurityStrength(strengths);
            return this;
        }

        public Builder realm(String realm) {
            this.object.setRealm(realm);
            return this;
        }

        public Builder property(String name, Object value) {
            this.object.setProperty(name, value);
            return this;
        }

        public SaslConfig build() {
            return this.object;
        }
    }
}

