/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import java.util.ArrayList;
import java.util.Arrays;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchResponse;
import org.ldaptive.SearchResultReference;
import org.ldaptive.handler.SearchResultHandler;
import org.ldaptive.referral.AbstractFollowSearchReferralHandler;
import org.ldaptive.referral.DefaultReferralConnectionFactory;
import org.ldaptive.referral.FollowSearchReferralHandler;
import org.ldaptive.referral.ReferralConnectionFactory;
import org.ldaptive.transport.DefaultSearchOperationHandle;

public class FollowSearchResultReferenceHandler
extends AbstractFollowSearchReferralHandler
implements SearchResultHandler {
    public FollowSearchResultReferenceHandler() {
        this(10, 1, new DefaultReferralConnectionFactory(), false);
    }

    public FollowSearchResultReferenceHandler(ReferralConnectionFactory factory) {
        this(10, 1, factory, false);
    }

    public FollowSearchResultReferenceHandler(ReferralConnectionFactory factory, boolean tf) {
        this(10, 1, factory, tf);
    }

    public FollowSearchResultReferenceHandler(int limit) {
        this(limit, 1, new DefaultReferralConnectionFactory(), false);
    }

    public FollowSearchResultReferenceHandler(int limit, ReferralConnectionFactory factory) {
        this(limit, 1, factory, false);
    }

    public FollowSearchResultReferenceHandler(int limit, ReferralConnectionFactory factory, boolean tf) {
        this(limit, 1, factory, tf);
    }

    FollowSearchResultReferenceHandler(int limit, int depth, ReferralConnectionFactory factory, boolean tf) {
        super(limit, depth, factory, tf);
    }

    @Override
    protected SearchResultHandler[] createNextSearchResultHandler() {
        boolean hasSearchReferralHandler;
        DefaultSearchOperationHandle handle = (DefaultSearchOperationHandle)this.getHandle();
        boolean bl = hasSearchReferralHandler = handle.getOnReferralResult() instanceof FollowSearchReferralHandler || handle.getOnSearchResult() != null && Arrays.stream(handle.getOnSearchResult()).anyMatch(h -> h instanceof FollowSearchReferralHandler);
        if (hasSearchReferralHandler) {
            return new SearchResultHandler[]{new FollowSearchReferralHandler(this.getReferralLimit(), this.getReferralDepth() + 1, this.getReferralConnectionFactory(), this.getThrowOnFailure()), new FollowSearchResultReferenceHandler(this.getReferralLimit(), this.getReferralDepth() + 1, this.getReferralConnectionFactory(), this.getThrowOnFailure())};
        }
        return new SearchResultHandler[]{new FollowSearchResultReferenceHandler(this.getReferralLimit(), this.getReferralDepth() + 1, this.getReferralConnectionFactory(), this.getThrowOnFailure())};
    }

    @Override
    public SearchResponse apply(SearchResponse result) {
        if (!result.isSuccess() || result.getReferences().isEmpty()) {
            return result;
        }
        if (this.referralDepth > this.referralLimit) {
            throw new RuntimeException(new LdapException(ResultCode.REFERRAL_LIMIT_EXCEEDED, "Referral limit of " + this.referralLimit + " exceeded"));
        }
        SearchResponse referralResult = SearchResponse.copy(result);
        ArrayList refsToAdd = new ArrayList();
        ArrayList<SearchResultReference> refsToRemove = new ArrayList<SearchResultReference>();
        for (SearchResultReference ref : referralResult.getReferences()) {
            SearchResponse sr;
            try {
                sr = (SearchResponse)this.followReferral(ref.getUris());
            }
            catch (LdapException e2) {
                throw new RuntimeException(e2);
            }
            if (sr != null && sr.getResultCode() == ResultCode.SUCCESS) {
                refsToRemove.add(ref);
                sr.getEntries().forEach(e -> referralResult.addEntries(LdapEntry.copy(e)));
                sr.getReferences().forEach(r -> refsToAdd.add(SearchResultReference.copy(r)));
                continue;
            }
            if (!this.getThrowOnFailure()) continue;
            throw new RuntimeException(new LdapException(ResultCode.LOCAL_ERROR, "Could not follow referral " + String.valueOf(referralResult)));
        }
        refsToRemove.forEach(xva$0 -> referralResult.removeReferences((SearchResultReference)xva$0));
        refsToAdd.forEach(xva$0 -> referralResult.addReferences((SearchResultReference)xva$0));
        return referralResult;
    }

    public FollowSearchResultReferenceHandler newInstance() {
        return new FollowSearchResultReferenceHandler(this.getReferralLimit(), this.getReferralDepth(), this.getReferralConnectionFactory(), this.getThrowOnFailure());
    }
}

