/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.dn;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ldaptive.LdapUtils;
import org.ldaptive.dn.AttributeValueEscaper;
import org.ldaptive.dn.DefaultAttributeValueEscaper;
import org.ldaptive.dn.NameValue;
import org.ldaptive.dn.RDn;
import org.ldaptive.dn.RDnNormalizer;

public class DefaultRDnNormalizer
implements RDnNormalizer {
    public static final Function<String, String> LOWERCASE = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return LdapUtils.toLowerCase(s);
        }

        public String toString() {
            return "LOWERCASE";
        }
    };
    public static final Function<String, String> COMPRESS = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return LdapUtils.compressSpace(s, false);
        }

        public String toString() {
            return "COMPRESS";
        }
    };
    public static final Function<String, String> LOWERCASE_COMPRESS = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return LdapUtils.toLowerCase(LdapUtils.compressSpace(s, false));
        }

        public String toString() {
            return "LOWERCASE_COMPRESS";
        }
    };
    public static final Comparator<NameValue> COMPARE_BY_NAME = new Comparator<NameValue>(){

        @Override
        public int compare(NameValue nv1, NameValue nv2) {
            return nv1.getName().compareTo(nv2.getName());
        }

        public String toString() {
            return "COMPARE_BY_NAME";
        }
    };
    private final Function<String, String> attributeNameFunction;
    private final Function<String, String> attributeValueFunction;
    private final AttributeValueEscaper attributeValueEscaper;
    private final Comparator<NameValue> nameValueComparator;

    public DefaultRDnNormalizer() {
        this(new DefaultAttributeValueEscaper(), LOWERCASE, LOWERCASE_COMPRESS);
    }

    public DefaultRDnNormalizer(AttributeValueEscaper escaper) {
        this(escaper, LOWERCASE, LOWERCASE_COMPRESS);
    }

    public DefaultRDnNormalizer(AttributeValueEscaper escaper, Function<String, String> nameNormalizer, Function<String, String> valueNormalizer) {
        this(escaper, nameNormalizer, valueNormalizer, COMPARE_BY_NAME);
    }

    public DefaultRDnNormalizer(AttributeValueEscaper escaper, Function<String, String> nameNormalizer, Function<String, String> valueNormalizer, Comparator<NameValue> comparator) {
        this.attributeValueEscaper = escaper;
        this.attributeNameFunction = nameNormalizer;
        this.attributeValueFunction = valueNormalizer;
        this.nameValueComparator = comparator;
    }

    public AttributeValueEscaper getValueEscaper() {
        return this.attributeValueEscaper;
    }

    public Function<String, String> getNameFunction() {
        return this.attributeNameFunction;
    }

    public Function<String, String> getValueFunction() {
        return this.attributeValueFunction;
    }

    @Override
    public RDn normalize(RDn rdn) {
        Set nameValues = rdn.getNameValues().stream().map(nv -> new NameValue(this.attributeNameFunction.apply(nv.getName()), this.attributeValueEscaper.escape(this.attributeValueFunction.apply(nv.getStringValue())))).sorted(this.nameValueComparator).collect(Collectors.toCollection(LinkedHashSet::new));
        return new RDn(nameValues);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::attributeNameFunction=" + String.valueOf(this.attributeNameFunction) + ", attributeValueFunction=" + String.valueOf(this.attributeValueFunction) + ", attributeValueEscaper=" + String.valueOf(this.attributeValueEscaper) + ", nameValueComparator=" + String.valueOf(this.nameValueComparator);
    }
}

