/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ldaptive.AbstractSearchOperationFactory;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.control.PagedResultsControl;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.util.CookieManager;
import org.ldaptive.control.util.DefaultCookieManager;

public class PagedResultsClient
extends AbstractSearchOperationFactory {
    private final int resultSize;

    public PagedResultsClient(ConnectionFactory cf, int size) {
        this.setConnectionFactory(cf);
        this.resultSize = size;
    }

    public SearchResponse execute(SearchRequest request) throws LdapException {
        return this.execute(request, new DefaultCookieManager());
    }

    public SearchResponse execute(SearchRequest request, SearchResponse result) throws LdapException {
        byte[] cookie = this.getPagedResultsCookie(result);
        if (cookie == null) {
            throw new IllegalArgumentException("Response does not contain a paged results cookie");
        }
        return this.execute(request, new DefaultCookieManager(cookie));
    }

    public SearchResponse execute(SearchRequest request, CookieManager manager) throws LdapException {
        SearchOperation search = this.createSearchOperation();
        request.setControls(this.appendRequestControls(request, manager.readCookie()));
        SearchResponse result = search.execute(request);
        byte[] cookie = this.getPagedResultsCookie(result);
        if (cookie != null) {
            manager.writeCookie(cookie);
        }
        return result;
    }

    public boolean hasMore(SearchResponse result) {
        return this.getPagedResultsCookie(result) != null;
    }

    public SearchResponse executeToCompletion(SearchRequest request) throws LdapException {
        return this.executeToCompletion(request, new DefaultCookieManager());
    }

    public SearchResponse executeToCompletion(SearchRequest request, CookieManager manager) throws LdapException {
        SearchResponse result = null;
        SearchResponse combinedResults = new SearchResponse();
        SearchOperation search = this.createSearchOperation();
        byte[] cookie = manager.readCookie();
        do {
            if (result != null) {
                combinedResults.addEntries(result.getEntries());
                combinedResults.addReferences(result.getReferences());
            }
            request.setControls(this.appendRequestControls(request, cookie));
            result = search.execute(request);
            cookie = this.getPagedResultsCookie(result);
            if (cookie == null) continue;
            manager.writeCookie(cookie);
        } while (cookie != null);
        SearchResponse finalResult = SearchResponse.copy(result);
        finalResult.addEntries(combinedResults.getEntries());
        finalResult.addReferences(combinedResults.getReferences());
        return finalResult;
    }

    public PagedResultsControl getResponseControl(SearchResponse result) {
        if (result == null) {
            return null;
        }
        return (PagedResultsControl)result.getControl("1.2.840.113556.1.4.319");
    }

    protected byte[] getPagedResultsCookie(SearchResponse result) {
        if (result == null) {
            return null;
        }
        byte[] cookie = null;
        PagedResultsControl ctl = (PagedResultsControl)result.getControl("1.2.840.113556.1.4.319");
        if (ctl != null && ctl.getCookie() != null && ctl.getCookie().length > 0) {
            cookie = ctl.getCookie();
        }
        return cookie;
    }

    private RequestControl[] appendRequestControls(SearchRequest request, byte[] cookie) {
        if (request.getControls() != null && request.getControls().length > 0) {
            List requestControls = Arrays.stream(request.getControls()).filter(c -> !(c instanceof PagedResultsControl)).collect(Collectors.toCollection(ArrayList::new));
            requestControls.add(new PagedResultsControl(this.resultSize, cookie, true));
            return (RequestControl[])requestControls.toArray(RequestControl[]::new);
        }
        return new RequestControl[]{new PagedResultsControl(this.resultSize, cookie, true)};
    }
}

