/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import org.ldaptive.RetryMetadata;

public abstract class AbstractRetryMetadata
implements RetryMetadata {
    protected Instant successTime;
    protected Instant failureTime;
    private final Instant createTime;
    private final AtomicInteger attempts = new AtomicInteger();

    public AbstractRetryMetadata() {
        this(Clock.systemDefaultZone());
    }

    protected AbstractRetryMetadata(Clock clock) {
        this.createTime = Instant.now(clock);
    }

    @Override
    public Instant getSuccessTime() {
        return this.successTime;
    }

    @Override
    public Instant getFailureTime() {
        return this.failureTime;
    }

    @Override
    public Instant getCreateTime() {
        return this.createTime;
    }

    @Override
    public int getAttempts() {
        return this.attempts.get();
    }

    @Override
    public void recordSuccess(Instant time) {
        this.successTime = time;
    }

    @Override
    public void recordFailure(Instant time) {
        this.failureTime = time;
        this.attempts.incrementAndGet();
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::attempts=" + String.valueOf(this.attempts) + ", failureTime=" + String.valueOf(this.failureTime);
    }
}

