/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapUtils;
import org.ldaptive.Operation;
import org.ldaptive.OperationHandle;
import org.ldaptive.Request;
import org.ldaptive.Result;
import org.ldaptive.handler.ExceptionHandler;
import org.ldaptive.handler.IntermediateResponseHandler;
import org.ldaptive.handler.ReferralHandler;
import org.ldaptive.handler.ReferralResultHandler;
import org.ldaptive.handler.RequestHandler;
import org.ldaptive.handler.ResponseControlHandler;
import org.ldaptive.handler.ResultHandler;
import org.ldaptive.handler.ResultPredicate;
import org.ldaptive.handler.UnsolicitedNotificationHandler;

public abstract class AbstractOperation<Q extends Request, S extends Result>
implements Operation<Q, S> {
    private ConnectionFactory connectionFactory;
    private RequestHandler<Q>[] requestHandlers;
    private ResultHandler[] resultHandlers;
    private ResponseControlHandler[] controlHandlers;
    private ReferralHandler[] referralHandlers;
    private IntermediateResponseHandler[] intermediateResponseHandlers;
    private ExceptionHandler exceptionHandler;
    private ResultPredicate throwCondition;
    private UnsolicitedNotificationHandler[] unsolicitedNotificationHandlers;
    private ReferralResultHandler<S> referralResultHandler;

    public AbstractOperation() {
    }

    public AbstractOperation(ConnectionFactory factory) {
        this.setConnectionFactory(factory);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public RequestHandler<Q>[] getRequestHandlers() {
        return this.requestHandlers;
    }

    public void setRequestHandlers(RequestHandler<Q> ... handlers) {
        this.requestHandlers = handlers;
    }

    public ResultHandler[] getResultHandlers() {
        return this.resultHandlers;
    }

    public void setResultHandlers(ResultHandler ... handlers) {
        this.resultHandlers = handlers;
    }

    public ResponseControlHandler[] getControlHandlers() {
        return this.controlHandlers;
    }

    public void setControlHandlers(ResponseControlHandler ... handlers) {
        this.controlHandlers = handlers;
    }

    public ReferralHandler[] getReferralHandlers() {
        return this.referralHandlers;
    }

    public void setReferralHandlers(ReferralHandler ... handlers) {
        this.referralHandlers = handlers;
    }

    public IntermediateResponseHandler[] getIntermediateResponseHandlers() {
        return this.intermediateResponseHandlers;
    }

    public void setIntermediateResponseHandlers(IntermediateResponseHandler ... handlers) {
        this.intermediateResponseHandlers = handlers;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler handler) {
        this.exceptionHandler = handler;
    }

    public ResultPredicate getThrowCondition() {
        return this.throwCondition;
    }

    public void setThrowCondition(ResultPredicate function) {
        this.throwCondition = function;
    }

    public UnsolicitedNotificationHandler[] getUnsolicitedNotificationHandlers() {
        return this.unsolicitedNotificationHandlers;
    }

    public void setUnsolicitedNotificationHandlers(UnsolicitedNotificationHandler ... handlers) {
        this.unsolicitedNotificationHandlers = handlers;
    }

    public ReferralResultHandler<S> getReferralResultHandler() {
        return this.referralResultHandler;
    }

    public void setReferralResultHandler(ReferralResultHandler<S> handler) {
        this.referralResultHandler = handler;
    }

    protected Q configureRequest(Q request) {
        if (this.requestHandlers == null || this.requestHandlers.length == 0) {
            return request;
        }
        for (RequestHandler<Q> func : this.requestHandlers) {
            func.accept(request);
        }
        return request;
    }

    protected OperationHandle<Q, S> configureHandle(OperationHandle<Q, S> handle) {
        return handle.onControl(this.getControlHandlers()).onReferral(this.getReferralHandlers()).onIntermediate(this.getIntermediateResponseHandlers()).onException(this.getExceptionHandler()).throwIf(this.getThrowCondition()).onUnsolicitedNotification(this.getUnsolicitedNotificationHandlers()).onReferralResult(this.getReferralResultHandler()).onResult(this.getResultHandlers());
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::connectionFactory=" + String.valueOf(this.connectionFactory) + ", requestHandlers=" + Arrays.toString(this.requestHandlers) + ", resultHandlers=" + Arrays.toString(this.resultHandlers) + ", controlHandlers=" + Arrays.toString(this.controlHandlers) + ", referralHandlers=" + Arrays.toString(this.referralHandlers) + ", intermediateResponseHandlers=" + Arrays.toString(this.intermediateResponseHandlers) + ", exceptionHandler=" + String.valueOf(this.exceptionHandler) + ", throwCondition=" + String.valueOf(this.throwCondition) + ", unsolicitedNotificationHandlers=" + Arrays.toString(this.unsolicitedNotificationHandlers) + ", referralResultHandler=" + String.valueOf(this.referralResultHandler);
    }

    protected static <Q extends Request, S extends Result> void copy(AbstractOperation<Q, S> from, AbstractOperation<Q, S> to, boolean deep) {
        to.requestHandlers = deep ? LdapUtils.copyArray(from.requestHandlers) : from.requestHandlers;
        to.resultHandlers = deep ? LdapUtils.copyArray(from.resultHandlers) : from.resultHandlers;
        to.controlHandlers = deep ? LdapUtils.copyArray(from.controlHandlers) : from.controlHandlers;
        to.referralHandlers = deep ? LdapUtils.copyArray(from.referralHandlers) : from.referralHandlers;
        to.intermediateResponseHandlers = deep ? LdapUtils.copyArray(from.intermediateResponseHandlers) : from.intermediateResponseHandlers;
        to.exceptionHandler = from.exceptionHandler;
        to.throwCondition = from.throwCondition;
        to.unsolicitedNotificationHandlers = deep ? LdapUtils.copyArray(from.unsolicitedNotificationHandlers) : from.unsolicitedNotificationHandlers;
        to.referralResultHandler = from.referralResultHandler;
        to.connectionFactory = from.connectionFactory;
    }

    protected static abstract class AbstractBuilder<B, T extends AbstractOperation> {
        protected final T object;

        protected AbstractBuilder(T t) {
            this.object = t;
        }

        protected abstract B self();

        public B factory(ConnectionFactory factory) {
            ((AbstractOperation)this.object).setConnectionFactory(factory);
            return this.self();
        }

        public B onRequest(RequestHandler ... handlers) {
            ((AbstractOperation)this.object).setRequestHandlers(handlers);
            return this.self();
        }

        public B onResult(ResultHandler ... handlers) {
            ((AbstractOperation)this.object).setResultHandlers(handlers);
            return this.self();
        }

        public B onControl(ResponseControlHandler ... handlers) {
            ((AbstractOperation)this.object).setControlHandlers(handlers);
            return this.self();
        }

        public B onReferral(ReferralHandler ... handlers) {
            ((AbstractOperation)this.object).setReferralHandlers(handlers);
            return this.self();
        }

        public B onIntermediate(IntermediateResponseHandler ... handlers) {
            ((AbstractOperation)this.object).setIntermediateResponseHandlers(handlers);
            return this.self();
        }

        public B onUnsolicitedNotification(UnsolicitedNotificationHandler ... handlers) {
            ((AbstractOperation)this.object).setUnsolicitedNotificationHandlers(handlers);
            return this.self();
        }

        public B onReferralResult(ReferralResultHandler handler) {
            ((AbstractOperation)this.object).setReferralResultHandler(handler);
            return this.self();
        }

        public B onException(ExceptionHandler handler) {
            ((AbstractOperation)this.object).setExceptionHandler(handler);
            return this.self();
        }

        public B throwIf(ResultPredicate function) {
            ((AbstractOperation)this.object).setThrowCondition(function);
            return this.self();
        }

        public T build() {
            return this.object;
        }
    }
}

