/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.spnego.impl.KerberosRealmSettings;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class KerberosSettings {
    @Nonnull
    @NotEmpty
    private String loginModuleClassName = "com.sun.security.auth.module.Krb5LoginModule";
    private boolean refreshKrb5Config;
    @Nonnull
    private Collection<KerberosRealmSettings> realmSettings = CollectionSupport.emptyList();

    public void setLoginModuleClassName(@Nonnull @NotEmpty String name) {
        this.loginModuleClassName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Class name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getLoginModuleClassName() {
        return this.loginModuleClassName;
    }

    public void setRefreshKrb5Config(boolean flag) {
        this.refreshKrb5Config = flag;
    }

    public boolean getRefreshKrb5Config() {
        return this.refreshKrb5Config;
    }

    public void setRealms(@Nullable Collection<KerberosRealmSettings> realms) {
        this.realmSettings = realms != null ? CollectionSupport.copyToList(realms) : CollectionSupport.emptyList();
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Collection<KerberosRealmSettings> getRealms() {
        return this.realmSettings;
    }
}

