/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.spnego.impl.GSSAcceptorLoginModule;
import net.shibboleth.idp.authn.spnego.impl.KerberosRealmSettings;
import net.shibboleth.idp.authn.spnego.impl.KerberosSettings;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;

public class GSSContextAcceptor {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GSSContextAcceptor.class);
    @Nonnull
    private final Oid spnegoOid;
    @Nonnull
    private KerberosSettings kerberosSettings;
    @Nullable
    private GSSAcceptorLoginModule krbLoginModule;
    @Nullable
    private GSSCredential serverCreds;
    @Nullable
    private GSSContext context;

    public GSSContextAcceptor(@Nonnull KerberosSettings settings) throws GSSException {
        this.kerberosSettings = settings;
        try {
            this.spnegoOid = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException e) {
            this.log.debug("Unable to create SPNEGO mechanism OID");
            throw e;
        }
    }

    @Nullable
    public GSSContext getContext() {
        return this.context;
    }

    @Nullable
    public byte[] acceptSecContext(@Nonnull byte[] inToken, int offset, int len) throws Exception {
        GSSContext ctxt = this.context;
        if (ctxt == null) {
            this.log.trace("Processing first GSS input token");
            return this.acceptFirstToken(inToken, offset, len);
        }
        this.log.trace("Processing an additional GSS input token");
        byte[] tokenOut = ctxt.acceptSecContext(inToken, offset, len);
        if (ctxt.isEstablished()) {
            this.log.trace("Security context established");
        } else {
            this.log.trace("Security context partially established");
        }
        return tokenOut;
    }

    public void logout() {
        if (this.context != null) {
            try {
                this.context.dispose();
                this.context = null;
            }
            catch (GSSException e) {
                this.log.error("GSS-API context disposal failed", (Throwable)e);
            }
        }
        if (this.serverCreds != null) {
            try {
                this.serverCreds.dispose();
                this.serverCreds = null;
            }
            catch (GSSException e) {
                this.log.error("GSS-API credentials disposal failed", (Throwable)e);
            }
        }
        if (this.krbLoginModule != null) {
            try {
                this.krbLoginModule.logout();
                this.krbLoginModule = null;
            }
            catch (LoginException e) {
                this.log.error("Server credentials logout failed", (Throwable)e);
            }
        }
    }

    @Nullable
    private byte[] acceptFirstToken(@Nonnull byte[] inToken, int offset, int len) throws Exception {
        Exception preserved = null;
        for (KerberosRealmSettings realm : this.kerberosSettings.getRealms()) {
            this.log.debug("Validating the first GSS input token against service principal: {}", (Object)realm.getServicePrincipal());
            try {
                this.createGSSContext(realm);
                assert (this.context != null);
                byte[] tokenOut = this.context.acceptSecContext(inToken, offset, len);
                assert (this.context != null);
                if (this.context.isEstablished()) {
                    this.log.trace("Security context fully established");
                } else {
                    this.log.trace("Security context partially established");
                }
                return tokenOut;
            }
            catch (Exception e) {
                this.log.debug("Error establishing security context", (Throwable)e);
                this.logout();
                preserved = e;
            }
        }
        throw (Exception)Constraint.isNotNull(preserved, (String)"No realms presented to GssContextAccpetor");
    }

    private void createGSSContext(@Nonnull KerberosRealmSettings realm) throws GSSException, LoginException, PrivilegedActionException {
        Subject krbSubject;
        this.krbLoginModule = new GSSAcceptorLoginModule(realm, this.kerberosSettings.getRefreshKrb5Config(), this.kerberosSettings.getLoginModuleClassName());
        try {
            krbSubject = this.krbLoginModule.login();
            assert (krbSubject != null);
        }
        catch (LoginException e) {
            this.log.error("Server login error using principal: {}", (Object)realm.getServicePrincipal());
            throw e;
        }
        this.log.trace("Server login successful using principal: {}", (Object)realm.getServicePrincipal());
        this.log.trace("Creating GSS credentials and context");
        GSSManager manager = GSSManager.getInstance();
        try {
            this.serverCreds = this.getServerCredential(krbSubject);
            this.context = manager.createContext(this.serverCreds);
        }
        catch (PrivilegedActionException e) {
            this.log.error("Error creating GSS credentials: {}", (Object)e.getMessage());
            throw e;
        }
        catch (GSSException e) {
            this.log.error("Error creating GSS acceptor context: {}", (Object)e.getMessage());
            throw e;
        }
        this.log.trace("GSS acceptor context created");
    }

    @Nonnull
    private GSSCredential getServerCredential(@Nonnull Subject subject) throws PrivilegedActionException {
        PrivilegedExceptionAction<GSSCredential> action = new PrivilegedExceptionAction<GSSCredential>(){

            @Override
            public GSSCredential run() throws GSSException {
                GSSManager manager = GSSManager.getInstance();
                GSSCredential newServerCreds = manager.createCredential(null, Integer.MAX_VALUE, GSSContextAcceptor.this.spnegoOid, 2);
                return newServerCreds;
            }
        };
        GSSCredential result = Subject.doAs(subject, action);
        assert (result != null);
        return result;
    }
}

