/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizer;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.cryptacular.x509.dn.Attribute;
import org.cryptacular.x509.dn.NameReader;
import org.cryptacular.x509.dn.RDN;
import org.cryptacular.x509.dn.RDNSequence;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;

public class X500SubjectCanonicalization
extends AbstractSubjectCanonicalizer {
    @Nonnull
    @NotEmpty
    private static final String CN_OID = "2.5.4.3";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(X500SubjectCanonicalization.class);
    @Nonnull
    private List<Integer> subjectAltNameTypes = CollectionSupport.emptyList();
    @Nonnull
    private List<String> objectIds = CollectionSupport.singletonList((Object)"2.5.4.3");

    public void setSubjectAltNameTypes(@Nullable List<Integer> types) {
        this.checkSetterPreconditions();
        this.subjectAltNameTypes = types != null ? CollectionSupport.copyToList(types) : CollectionSupport.emptyList();
    }

    public void setObjectIds(@Nullable List<String> ids) {
        this.checkSetterPreconditions();
        this.objectIds = CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(ids));
    }

    @Nullable
    protected String doApply(@Nonnull SubjectCanonicalizationContext c14nContext) {
        X509Certificate certificate = this.getCertificate(c14nContext);
        X500Principal x500Principal = certificate != null ? certificate.getSubjectX500Principal() : this.getX500Principal(c14nContext);
        if (x500Principal == null) {
            this.log.debug("{} Neither a single X509Certificate nor X500Principal were found", (Object)this.getLogPrefix());
            return null;
        }
        if (certificate != null && !this.subjectAltNameTypes.isEmpty()) {
            this.log.debug("{} Searching for subjectAltName types ({})", (Object)this.getLogPrefix(), this.subjectAltNameTypes);
            List altnames = X509Support.getAltNames((X509Certificate)certificate, (Integer[])this.subjectAltNameTypes.toArray(new Integer[0]));
            assert (altnames != null);
            for (Object altname : altnames) {
                if (!(altname instanceof String)) continue;
                this.log.debug("{} Extracted String-valued subjectAltName: {}", (Object)this.getLogPrefix(), altname);
                c14nContext.setPrincipalName(this.applyTransforms((String)altname));
                return "proceed";
            }
            this.log.debug("{} No suitable subjectAltName extension");
        }
        String x509PrincipalName = x500Principal.getName();
        this.log.debug("{} Searching for RDN to extract from DN: {}", (Object)this.getLogPrefix(), (Object)x509PrincipalName);
        try {
            RDNSequence dnAttrs = NameReader.readX500Principal((X500Principal)x500Principal);
            assert (dnAttrs != null);
            for (String oid : this.objectIds) {
                assert (oid != null);
                String rdn = this.findRDN(dnAttrs, oid);
                if (rdn == null) continue;
                this.log.debug("{} Extracted RDN with OID {}: {}", new Object[]{this.getLogPrefix(), oid, rdn});
                c14nContext.setPrincipalName(this.applyTransforms(rdn));
                return "proceed";
            }
            this.log.warn("{} Unable to extract a suitable RDN from DN: {}", (Object)this.getLogPrefix(), (Object)x509PrincipalName);
            return "InvalidSubject";
        }
        catch (IllegalArgumentException e) {
            this.log.warn("{} Unable to parse subject DN: {}", new Object[]{this.getLogPrefix(), x509PrincipalName, e});
            return "InvalidSubject";
        }
    }

    @Nullable
    protected String findRDN(@Nonnull RDNSequence sequence, @Nonnull @NotEmpty String oid) {
        for (RDN rdn : sequence.backward()) {
            for (Attribute attribute : rdn.getAttributes()) {
                if (!attribute.getType().getOid().equals(oid)) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    @Nullable
    private X500Principal getX500Principal(@Nonnull SubjectCanonicalizationContext c14nContext) {
        Set<X500Principal> prins;
        Subject subject = c14nContext.getSubject();
        if (subject != null && (prins = subject.getPrincipals(X500Principal.class)) != null && prins.size() == 1) {
            return prins.iterator().next();
        }
        return null;
    }

    @Nullable
    private X509Certificate getCertificate(@Nonnull SubjectCanonicalizationContext c14nContext) {
        Set<X509Certificate> certificates;
        Subject subject = c14nContext.getSubject();
        if (subject != null && (certificates = subject.getPublicCredentials(X509Certificate.class)) != null && certificates.size() == 1) {
            return certificates.iterator().next();
        }
        return null;
    }
}

