/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.SubjectCanonicalizer;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SelectSubjectCanonicalizationFlow
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectSubjectCanonicalizationFlow.class);

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        if (!super.doPreExecute(profileRequestContext, c14nContext)) {
            return false;
        }
        SubjectCanonicalizationFlowDescriptor flow = c14nContext.getAttemptedFlow();
        if (flow != null) {
            c14nContext.getIntermediateFlows().put(flow.ensureId(), c14nContext.getAttemptedFlow());
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        SubjectCanonicalizationFlowDescriptor flow = this.selectUnattemptedFlow(profileRequestContext, c14nContext);
        if (flow == null) {
            this.log.warn("{} No potential flows left to choose from, c14n will fail", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoPotentialFlow");
            return;
        }
        if (flow instanceof SubjectCanonicalizer) {
            SubjectCanonicalizer sc = (SubjectCanonicalizer)flow;
            this.log.debug("{} Selecting c14n descriptor {} (Inline implementation)", (Object)this.getLogPrefix(), (Object)flow.ensureId());
            String event = (String)sc.apply((Object)c14nContext);
            if ("proceed".equals(event)) {
                this.log.debug("{} Inline c14n implementation {} completed successfully", (Object)this.getLogPrefix(), (Object)flow.ensureId());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"SubjectCanonicalizationCompleted");
            } else if (event != null) {
                this.log.warn("{} Inline c14n implementation {} failed with event: {}", new Object[]{this.getLogPrefix(), flow.ensureId(), event});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)event);
            } else {
                this.log.debug("{} Inline c14n implementation {} was not applicable", (Object)this.getLogPrefix(), (Object)flow.ensureId());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"ReselectFlow");
            }
        } else {
            String flowId = flow.getFlowId();
            assert (flowId != null);
            this.log.debug("{} Selecting c14n descriptor {} (WebFlow ID: {})", new Object[]{this.getLogPrefix(), flow.ensureId(), flow.getFlowId()});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)flowId);
        }
    }

    @Nullable
    private SubjectCanonicalizationFlowDescriptor selectUnattemptedFlow(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        for (SubjectCanonicalizationFlowDescriptor flow : c14nContext.getPotentialFlows().values()) {
            if (c14nContext.getIntermediateFlows().containsKey(flow.ensureId())) continue;
            c14nContext.setAttemptedFlow(flow);
            if (flow.test(profileRequestContext)) {
                c14nContext.setException(null);
                return flow;
            }
            this.log.info("{} Flow descriptor {} was not active", (Object)this.getLogPrefix(), (Object)flow.getId());
        }
        return null;
    }
}

