/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractExtractionAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.EncryptedCookieManager;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PrePopulateUsername
extends AbstractExtractionAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PrePopulateUsername.class);
    @Nonnull
    private Function<ProfileRequestContext, UsernamePasswordContext> usernamePasswordContextCreationStrategy = new ChildContextLookup(UsernamePasswordContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    @NotEmpty
    private String usernameFieldName = "j_username";
    @Nullable
    private EncryptedCookieManager cookieManager;
    @Nonnull
    private List<String> precedence = CollectionSupport.listOf((Object[])new String[]{"form", "session", "cookie"});
    @NonnullBeforeExec
    private UsernamePasswordContext usernameContext;

    public void setUsernamePasswordContextCreationStrategy(@Nonnull Function<ProfileRequestContext, UsernamePasswordContext> strategy) {
        this.checkSetterPreconditions();
        this.usernamePasswordContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"DuoPasswordlessContext lookup strategy cannot be null");
    }

    public void setUsernameFieldName(@Nonnull String name) {
        this.checkSetterPreconditions();
        this.usernameFieldName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Username form field name cannot be null or empty");
    }

    public void setEncryptedCookieManager(@Nullable EncryptedCookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = manager;
    }

    public void setPrecedence(@Nonnull Collection<String> order) {
        this.checkSetterPreconditions();
        this.precedence = CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(order));
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.usernameContext = this.usernamePasswordContextCreationStrategy.apply(profileRequestContext);
        if (this.usernameContext == null) {
            this.log.warn("{} Unable to create UsernamePasswordContext, skipping action", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.usernameContext.setUsername(null);
        this.usernameContext.setPassword(null);
        Iterator<String> iterator = this.precedence.iterator();
        block10: while (iterator.hasNext()) {
            String source;
            switch (source = iterator.next()) {
                case "form": {
                    String username = this.getUsernameFromForm(profileRequestContext);
                    if (username == null || username.isEmpty()) continue block10;
                    this.log.debug("{} Populating username '{}' from form submission into UsernamePasswordContext", (Object)this.getLogPrefix(), (Object)username);
                    this.usernameContext.setUsername(username);
                    return;
                }
                case "session": {
                    String username = this.getUsernameFromSession(profileRequestContext, authenticationContext);
                    if (username == null || username.isEmpty()) continue block10;
                    this.log.debug("{} Populating username '{}' from session into UsernamePasswordContext", (Object)this.getLogPrefix(), (Object)username);
                    this.usernameContext.setUsername(username);
                    return;
                }
                case "cookie": {
                    String username = this.getUsernameFromCookie(profileRequestContext);
                    if (username == null || username.isEmpty()) continue block10;
                    this.log.debug("{} Populating cached username '{}' from cookie into UsernamePasswordContext", (Object)this.getLogPrefix(), (Object)username);
                    this.usernameContext.setUsername(username);
                    return;
                }
            }
            this.log.warn("{} Unsupported precedence value for username population: {}", (Object)this.getLogPrefix(), (Object)source);
        }
    }

    @Nullable
    private String getUsernameFromForm(@Nonnull ProfileRequestContext profileRequestContext) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request != null) {
            return this.applyTransforms(profileRequestContext, request.getParameter(this.usernameFieldName));
        }
        return null;
    }

    @Nullable
    private String getUsernameFromCookie(@Nonnull ProfileRequestContext profileRequestContext) {
        return this.cookieManager != null ? this.cookieManager.readCookie() : null;
    }

    @Nullable
    private String getUsernameFromSession(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        IdPSession idpSession;
        SessionContext sessionContext;
        if (!authenticationContext.getActiveResults().isEmpty() && (sessionContext = (SessionContext)profileRequestContext.getSubcontext(SessionContext.class)) != null && (idpSession = sessionContext.getIdPSession()) != null) {
            return idpSession.getPrincipalName();
        }
        return null;
    }
}

